/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.hsqldb.Column;
import org.hsqldb.Constraint;
import org.hsqldb.Database;
import org.hsqldb.HsqlName;
import org.hsqldb.Index;
import org.hsqldb.Node;
import org.hsqldb.Result;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.TriggerDef;
import org.hsqldb.User;
import org.hsqldb.UserManager;
import org.hsqldb.View;

class DatabaseScript {
    DatabaseScript() {
    }

    static Result getScript(Database database, boolean bl, boolean bl2, boolean bl3, Session session) throws SQLException {
        int n;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        int n2;
        int n3;
        Object object5;
        int n4;
        StringBuffer stringBuffer;
        Vector vector = database.getTables();
        Vector vector2 = new Vector();
        Vector vector3 = new Vector();
        session.checkAdmin();
        Result result = new Result(1);
        result.colType[0] = 12;
        result.sTable[0] = "SYSTEM_SCRIPT";
        result.sLabel[0] = "COMMAND";
        result.sName[0] = "COMMAND";
        int n5 = 0;
        int n6 = vector.size();
        while (n5 < n6) {
            Table table = (Table)vector.elementAt(n5);
            if (!table.isTemp() && !table.isView()) {
                int n7;
                if (bl) {
                    DatabaseScript.addRow(result, "DROP TABLE " + table.getName().statementName);
                }
                stringBuffer = new StringBuffer(128);
                DatabaseScript.getTableDDL(database, table, n5, vector2, vector3, stringBuffer);
                DatabaseScript.addRow(result, stringBuffer.toString());
                n4 = 1;
                while (n4 < table.getIndexCount()) {
                    object5 = table.getIndex(n4);
                    if (!HsqlName.isReservedName(((Index)object5).getName().name)) {
                        stringBuffer = new StringBuffer(64);
                        stringBuffer.append("CREATE ");
                        if (((Index)object5).isUnique()) {
                            stringBuffer.append("UNIQUE ");
                        }
                        stringBuffer.append("INDEX ");
                        stringBuffer.append(((Index)object5).getName().statementName);
                        stringBuffer.append(" ON ");
                        stringBuffer.append(table.getName().statementName);
                        int[] nArray = ((Index)object5).getColumns();
                        n7 = ((Index)object5).getVisibleColumns();
                        DatabaseScript.getColumnList(table, nArray, n7, stringBuffer);
                        DatabaseScript.addRow(result, stringBuffer.toString());
                    }
                    ++n4;
                }
                if (table.isText() && table.isDataReadOnly()) {
                    stringBuffer = new StringBuffer("SET TABLE ");
                    stringBuffer.append(table.getName().statementName);
                    stringBuffer.append(" READONLY TRUE");
                    DatabaseScript.addRow(result, stringBuffer.toString());
                }
                if ((object5 = DatabaseScript.getDataSource(table)) != null) {
                    DatabaseScript.addRow(result, (String)object5);
                }
                n3 = TriggerDef.numTrigs();
                n7 = 0;
                while (n7 < n3) {
                    Vector vector4 = table.vTrigs[n7];
                    n2 = vector4.size();
                    int n8 = 0;
                    while (n8 < n2) {
                        stringBuffer = ((TriggerDef)vector4.elementAt(n8)).toBuf();
                        DatabaseScript.addRow(result, stringBuffer.toString());
                        ++n8;
                    }
                    ++n7;
                }
            }
            ++n5;
        }
        int n9 = 0;
        n4 = vector2.size();
        while (n9 < n4) {
            object5 = (Constraint)vector2.elementAt(n9);
            stringBuffer = new StringBuffer(128);
            stringBuffer.append("ALTER TABLE ");
            stringBuffer.append(((Constraint)object5).getRef().getName().statementName);
            stringBuffer.append(" ADD ");
            DatabaseScript.getFKStatement((Constraint)object5, stringBuffer);
            DatabaseScript.addRow(result, stringBuffer.toString());
            ++n9;
        }
        int n10 = 0;
        n3 = vector.size();
        while (n10 < n3) {
            Table table = (Table)vector.elementAt(n10);
            if (bl3 && table.isCached()) {
                DatabaseScript.addRow(result, DatabaseScript.getIndexRootsDDL((Table)vector.elementAt(n10)));
            }
            ++n10;
        }
        Vector vector5 = database.getUserManager().getUsers();
        int n11 = 0;
        n2 = vector5.size();
        while (n11 < n2) {
            User user = (User)vector5.elementAt(n11);
            if (user != null) {
                object4 = user.getName();
                if (!((String)object4).equals("PUBLIC")) {
                    stringBuffer = new StringBuffer(128);
                    stringBuffer.append("CREATE USER ");
                    stringBuffer.append((String)object4);
                    stringBuffer.append(" PASSWORD ");
                    stringBuffer.append('\"');
                    stringBuffer.append(user.getPassword());
                    stringBuffer.append('\"');
                    if (user.isAdmin()) {
                        stringBuffer.append(" ADMIN");
                    }
                    DatabaseScript.addRow(result, stringBuffer.toString());
                }
                if ((object3 = user.getRights()) != null) {
                    object2 = ((Hashtable)object3).keys();
                    while (object2.hasMoreElements()) {
                        object = (String)object2.nextElement();
                        n = (Integer)((Hashtable)object3).get(object);
                        if (n == 0) continue;
                        stringBuffer = new StringBuffer(64);
                        stringBuffer.append("GRANT ");
                        stringBuffer.append(UserManager.getRight(n));
                        stringBuffer.append(" ON ");
                        stringBuffer.append((String)object);
                        stringBuffer.append(" TO ");
                        stringBuffer.append(user.getName());
                        DatabaseScript.addRow(result, stringBuffer.toString());
                    }
                }
            }
            ++n11;
        }
        if (database.isIgnoreCase()) {
            DatabaseScript.addRow(result, "SET IGNORECASE TRUE");
        }
        Hashtable hashtable = database.getAlias();
        object4 = hashtable.keys();
        while (object4.hasMoreElements()) {
            object3 = (String)object4.nextElement();
            object2 = (String)hashtable.get(object3);
            object = new StringBuffer(64);
            ((StringBuffer)object).append("CREATE ALIAS ");
            ((StringBuffer)object).append((String)object3);
            ((StringBuffer)object).append(" FOR \"");
            ((StringBuffer)object).append((String)object2);
            ((StringBuffer)object).append('\"');
            DatabaseScript.addRow(result, ((StringBuffer)object).toString());
        }
        int n12 = 0;
        int n13 = vector.size();
        while (n12 < n13) {
            object = (Table)vector.elementAt(n12);
            if (((Table)object).isView()) {
                View view = (View)vector.elementAt(n12);
                if (bl) {
                    DatabaseScript.addRow(result, "DROP VIEW " + view.getName().name);
                }
                stringBuffer = new StringBuffer(128);
                stringBuffer.append("CREATE ");
                stringBuffer.append("VIEW ");
                stringBuffer.append(view.getName().statementName);
                stringBuffer.append(" AS ");
                stringBuffer.append(view.getStatement());
                DatabaseScript.addRow(result, stringBuffer.toString());
            }
            ++n12;
        }
        int n14 = 0;
        n = vector.size();
        while (n14 < n) {
            Table table = (Table)vector.elementAt(n14);
            if (!(!bl2 || table.isTemp() || table.isView() || table.isCached && !bl3 || table.isText() && table.isDataReadOnly())) {
                Index index = table.getPrimaryIndex();
                Node node = index.first();
                boolean bl4 = true;
                if (node != null) {
                    bl4 = false;
                }
                while (node != null) {
                    DatabaseScript.addRow(result, table.getInsertStatement(node.getData()));
                    node = index.next(node);
                }
                if (table.isDataReadOnly()) {
                    stringBuffer = new StringBuffer("SET TABLE ");
                    stringBuffer.append(table.getName().statementName);
                    stringBuffer.append(" READONLY TRUE");
                    DatabaseScript.addRow(result, stringBuffer.toString());
                }
            }
            ++n14;
        }
        return result;
    }

    static String getIndexRootsDDL(Table table) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("SET TABLE ");
        stringBuffer.append(table.getName().statementName);
        stringBuffer.append(" INDEX '");
        stringBuffer.append(table.getIndexRoots());
        stringBuffer.append('\'');
        return stringBuffer.toString();
    }

    static void getTableDDL(Database database, Table table, int n, Vector vector, Vector vector2, StringBuffer stringBuffer) throws SQLException {
        Object object;
        stringBuffer.append("CREATE ");
        if (table.isText()) {
            stringBuffer.append("TEXT ");
        } else if (table.isCached()) {
            stringBuffer.append("CACHED ");
        }
        stringBuffer.append("TABLE ");
        stringBuffer.append(table.getName().statementName);
        stringBuffer.append('(');
        int n2 = table.getColumnCount();
        Index index = table.getIndex(0);
        int[] nArray = index.getColumns();
        int n3 = 0;
        while (n3 < n2) {
            object = table.getColumn(n3);
            String string = ((Column)object).columnName.statementName;
            stringBuffer.append(string);
            stringBuffer.append(' ');
            String string2 = Column.getTypeString(((Column)object).getType());
            stringBuffer.append(string2);
            if (((Column)object).getSize() > 0) {
                stringBuffer.append('(');
                stringBuffer.append(((Column)object).getSize());
                if (((Column)object).getScale() > 0) {
                    stringBuffer.append(',');
                    stringBuffer.append(((Column)object).getScale());
                }
                stringBuffer.append(')');
            }
            if (((Column)object).getDefaultString() != null) {
                stringBuffer.append(" DEFAULT ");
                stringBuffer.append(Column.createSQLString(((Column)object).getDefaultString()));
            }
            if (!((Column)object).isNullable()) {
                stringBuffer.append(" NOT NULL");
            }
            if (n3 == table.getIdentityColumn()) {
                stringBuffer.append(" IDENTITY");
            }
            if (nArray.length == 1 && n3 == nArray[0]) {
                stringBuffer.append(" PRIMARY KEY");
            }
            if (n3 < n2 - 1) {
                stringBuffer.append(',');
            }
            ++n3;
        }
        if (nArray.length > 1) {
            stringBuffer.append(",CONSTRAINT ");
            stringBuffer.append(index.getName().statementName);
            stringBuffer.append(" PRIMARY KEY");
            DatabaseScript.getColumnList(table, nArray, nArray.length, stringBuffer);
        }
        object = table.getConstraints();
        int n4 = 0;
        int n5 = ((Vector)object).size();
        while (n4 < n5) {
            Object object2;
            Constraint constraint = (Constraint)((Vector)object).elementAt(n4);
            if (constraint.getType() == 2) {
                stringBuffer.append(",CONSTRAINT ");
                stringBuffer.append(constraint.getName().statementName);
                stringBuffer.append(" UNIQUE");
                object2 = constraint.getMainColumns();
                DatabaseScript.getColumnList(constraint.getMain(), (int[])object2, ((Object)object2).length, stringBuffer);
            } else if (constraint.getType() == 0) {
                object2 = constraint.getMain();
                int n6 = database.getTableIndex((Table)object2);
                if (n6 > n) {
                    if (n >= vector2.size()) {
                        vector2.setSize(n + 1);
                    }
                    vector2.setElementAt(constraint, n);
                    vector.addElement(constraint);
                } else {
                    stringBuffer.append(',');
                    DatabaseScript.getFKStatement(constraint, stringBuffer);
                }
            }
            ++n4;
        }
        stringBuffer.append(')');
    }

    static String getDataSource(Table table) throws SQLException {
        String string = table.getDataSource();
        if (string == null) {
            return null;
        }
        boolean bl = table.isDescDataSource();
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("SET TABLE ");
        stringBuffer.append(table.getName().statementName);
        stringBuffer.append(" SOURCE \"");
        stringBuffer.append(string);
        stringBuffer.append('\"');
        if (bl) {
            stringBuffer.append(" DESC");
        }
        return stringBuffer.toString();
    }

    private static void getColumnList(Table table, int[] nArray, int n, StringBuffer stringBuffer) {
        stringBuffer.append('(');
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(table.getColumn((int)nArray[n2]).columnName.statementName);
            if (n2 < n - 1) {
                stringBuffer.append(',');
            }
            ++n2;
        }
        stringBuffer.append(')');
    }

    private static void getFKStatement(Constraint constraint, StringBuffer stringBuffer) {
        stringBuffer.append("CONSTRAINT ");
        stringBuffer.append(constraint.getName().statementName);
        stringBuffer.append(" FOREIGN KEY");
        int[] nArray = constraint.getRefColumns();
        DatabaseScript.getColumnList(constraint.getRef(), nArray, nArray.length, stringBuffer);
        stringBuffer.append(" REFERENCES ");
        stringBuffer.append(constraint.getMain().getName().statementName);
        nArray = constraint.getMainColumns();
        DatabaseScript.getColumnList(constraint.getMain(), nArray, nArray.length, stringBuffer);
        if (constraint.isCascade()) {
            stringBuffer.append(" ON DELETE CASCADE");
        }
    }

    private static void addRow(Result result, String string) {
        Object[] objectArray = new String[]{string};
        result.add(objectArray);
    }
}

