/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.renderer;

import java.awt.Color;
import java.awt.Component;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jdesktop.swingx.RolloverRenderer;
import org.jdesktop.swingx.renderer.CellContext;
import org.jdesktop.swingx.renderer.ComponentProvider;
import org.jdesktop.swingx.renderer.IconValue;
import org.jdesktop.swingx.renderer.LabelProvider;
import org.jdesktop.swingx.renderer.ListCellContext;
import org.jdesktop.swingx.renderer.MappedValue;
import org.jdesktop.swingx.renderer.StringValue;

public class DefaultListRenderer
implements ListCellRenderer,
RolloverRenderer,
Serializable {
    protected ComponentProvider componentController;
    protected CellContext<JList> cellContext;

    public DefaultListRenderer() {
        this((ComponentProvider)null);
    }

    public DefaultListRenderer(ComponentProvider componentController) {
        if (componentController == null) {
            componentController = new LabelProvider(this.createDefaultStringValue());
        }
        this.componentController = componentController;
        this.cellContext = new ListCellContext();
    }

    private StringValue createDefaultStringValue() {
        StringValue sv = new StringValue(){

            public String getString(Object value) {
                if (value instanceof Icon) {
                    return "";
                }
                return StringValue.TO_STRING.getString(value);
            }
        };
        return new MappedValue(sv, IconValue.ICON);
    }

    public DefaultListRenderer(StringValue converter) {
        this(new LabelProvider(converter));
    }

    public DefaultListRenderer(StringValue converter, int alignment) {
        this(new LabelProvider(converter, alignment));
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.cellContext.installContext(list, value, index, 0, isSelected, cellHasFocus, true, true);
        return this.componentController.getRendererComponent(this.cellContext);
    }

    public void setBackground(Color background) {
        this.componentController.getRendererController().setBackground(background);
    }

    public void setForeground(Color foreground) {
        this.componentController.getRendererController().setForeground(foreground);
    }

    public void doClick() {
        if (this.isEnabled()) {
            ((RolloverRenderer)((Object)this.componentController)).doClick();
        }
    }

    public boolean isEnabled() {
        return this.componentController instanceof RolloverRenderer && ((RolloverRenderer)((Object)this.componentController)).isEnabled();
    }
}

