/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.outline.nodes.properties;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.undo.ObjectPropertyUndoableEdit;
import java.lang.reflect.InvocationTargetException;
import net.sf.jasperreports.engine.design.JRDesignSubreport;
import org.openide.nodes.PropertySupport;

public final class SubreportUsingCacheProperty
extends PropertySupport.ReadWrite {
    private final JRDesignSubreport element;

    public SubreportUsingCacheProperty(JRDesignSubreport element) {
        super("usingCache", Boolean.class, "Use Cache", "Set if the subreport must be cached when loaded.");
        this.element = element;
    }

    public Object getValue() throws IllegalAccessException, InvocationTargetException {
        return this.element.isUsingCache();
    }

    public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (val == null || val instanceof Boolean) {
            Boolean oldValue = this.element.isOwnUsingCache();
            Boolean newValue = (Boolean)val;
            this.element.setUsingCache(newValue);
            ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.element, "UsingCache", Boolean.class, oldValue, newValue);
            IReportManager.getInstance().addUndoableEdit(urob);
        }
    }

    public boolean isDefaultValue() {
        return this.element.isOwnUsingCache() == null;
    }

    public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
        this.setValue(null);
    }

    public boolean supportsDefaultValue() {
        return true;
    }
}

