/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.outline.nodes.properties;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.sheet.Tag;
import com.jaspersoft.ireport.designer.sheet.editors.ComboBoxPropertyEditor;
import com.jaspersoft.ireport.designer.undo.ObjectPropertyUndoableEdit;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import net.sf.jasperreports.engine.design.JRDesignElement;
import org.openide.nodes.PropertySupport;

public final class StretchTypeProperty
extends PropertySupport {
    private final JRDesignElement element;
    private ComboBoxPropertyEditor editor;

    public StretchTypeProperty(JRDesignElement element) {
        super("stretchType", Byte.class, "Stretch type", "How to stretch the element.", true, true);
        this.element = element;
        this.setValue("suppressCustomEditor", Boolean.TRUE);
    }

    public PropertyEditor getPropertyEditor() {
        if (this.editor == null) {
            ArrayList<Tag> l = new ArrayList<Tag>();
            l.add(new Tag(new Byte(0), "No stretch"));
            l.add(new Tag(new Byte(2), "Relative to Band Height"));
            l.add(new Tag(new Byte(1), "Relative to Tallest Object"));
            this.editor = new ComboBoxPropertyEditor(false, l);
        }
        return this.editor;
    }

    public Object getValue() throws IllegalAccessException, InvocationTargetException {
        return new Byte(this.element.getStretchType());
    }

    public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        this.setPropertyValue(val);
    }

    public boolean isDefaultValue() {
        return this.element.getStretchType() == 0;
    }

    public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
        this.setPropertyValue((byte)0);
    }

    public boolean supportsDefaultValue() {
        return true;
    }

    private void setPropertyValue(Object val) {
        if (val instanceof Byte) {
            Byte oldValue = this.element.getStretchType();
            Byte newValue = (Byte)val;
            this.element.setStretchType(newValue.byteValue());
            ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.element, "StretchType", Byte.TYPE, oldValue, newValue);
            IReportManager.getInstance().addUndoableEdit(urob);
        }
    }
}

