/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.outline.nodes.properties;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.undo.ObjectPropertyUndoableEdit;
import java.lang.reflect.InvocationTargetException;
import net.sf.jasperreports.engine.design.JRDesignImage;
import org.openide.nodes.PropertySupport;

public final class ImageUsingCacheProperty
extends PropertySupport.ReadWrite {
    private final JRDesignImage element;

    public ImageUsingCacheProperty(JRDesignImage element) {
        super("usingCache", Boolean.class, "Using Cache", "Set if an the image should be cached filling the report.");
        this.element = element;
    }

    public Object getValue() throws IllegalAccessException, InvocationTargetException {
        return this.element.isUsingCache();
    }

    public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (val == null || val instanceof Boolean) {
            Boolean oldValue = this.element.isOwnUsingCache();
            Boolean newValue = (Boolean)val;
            this.element.setUsingCache(newValue);
            ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.element, "UsingCache", Boolean.class, oldValue, newValue);
            IReportManager.getInstance().addUndoableEdit(urob);
        }
    }

    public boolean isDefaultValue() {
        return this.element.isOwnUsingCache() == null;
    }

    public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
        this.setValue(null);
    }

    public boolean supportsDefaultValue() {
        return true;
    }
}

