/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer;

import com.jaspersoft.ireport.designer.ReportObjectScene;
import com.jaspersoft.ireport.designer.dnd.DesignerDropTarget;
import com.jaspersoft.ireport.designer.ruler.RulerPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.jdesktop.layout.GroupLayout;

public class ReportDesignerPanel
extends JPanel {
    private List<JasperDesignObserver> observers = new ArrayList<JasperDesignObserver>();
    JasperDesign jasperDesign = null;
    private RulerPanel hRuler = null;
    private RulerPanel vRuler = null;
    private ReportObjectScene scene = null;
    private JComponent myView = null;
    private static double[] zoomSteps = new double[]{0.25, 0.5, 0.75, 1.0, 1.5, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0};
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPaneMainReport;

    public RulerPanel getHRuler() {
        return this.hRuler;
    }

    public RulerPanel getVRuler() {
        return this.vRuler;
    }

    public boolean isGridVisible() {
        return this.getScene().isGridVisible();
    }

    public void setGridVisible(boolean b) {
        this.getScene().setGridVisible(b);
    }

    public boolean isSnapToGrid() {
        return this.getScene().isSnapToGrid();
    }

    public void setSnapToGrid(boolean b) {
        this.getScene().setSnapToGrid(b);
    }

    public JasperDesign getJasperDesign() {
        return this.jasperDesign;
    }

    public void setJasperDesign(JasperDesign jasperDesign) {
        this.jasperDesign = jasperDesign;
        this.getScene().setJasperDesign(jasperDesign);
        if (jasperDesign == null) {
            return;
        }
        for (JasperDesignObserver jdo : this.observers) {
            jdo.jasperDesignAvailable(this.jasperDesign);
        }
        this.observers.clear();
    }

    public ReportDesignerPanel() {
        this.initComponents();
        this.scene = new ReportObjectScene();
        this.myView = this.scene.getJComponent();
        this.jScrollPaneMainReport.setViewportView(this.myView);
        this.hRuler = new RulerPanel(this);
        this.myView.addMouseMotionListener(this.hRuler);
        this.hRuler.addGuideLineChangedListener(this.scene);
        this.jPanel1.add((Component)this.hRuler, "Center");
        this.vRuler = new RulerPanel(this);
        this.vRuler.setVertical(true);
        this.myView.addMouseMotionListener(this.vRuler);
        this.vRuler.addGuideLineChangedListener(this.scene);
        this.jPanel2.add((Component)this.vRuler, "Center");
        this.myView.setDropTarget(new DesignerDropTarget(this.scene));
    }

    public void zoomIn() {
        double zoom = this.getScene().getZoomFactor();
        for (int i = 0; i < zoomSteps.length; ++i) {
            if (!(zoom < zoomSteps[i])) continue;
            zoom = zoomSteps[i];
            break;
        }
        this.getScene().setZoomFactor(zoom);
        this.getScene().validate();
    }

    public void zoomOut() {
        double zoom = this.getScene().getZoomFactor();
        for (int i = zoomSteps.length - 1; i >= 0; --i) {
            if (!(zoom > zoomSteps[i])) continue;
            zoom = zoomSteps[i];
            break;
        }
        this.getScene().setZoomFactor(zoom);
        this.getScene().validate();
    }

    private void initComponents() {
        this.jScrollPaneMainReport = new JScrollPane();
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jScrollPaneMainReport.setBorder(null);
        this.jPanel1.setMinimumSize(new Dimension(100, 20));
        this.jPanel1.setPreferredSize(new Dimension(100, 20));
        this.jPanel1.setLayout(new BorderLayout());
        this.jPanel2.setBackground(new Color(255, 255, 204));
        this.jPanel2.setMinimumSize(new Dimension(20, 0));
        this.jPanel2.setPreferredSize(new Dimension(20, 0));
        this.jPanel2.setLayout(new BorderLayout());
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jPanel2, -2, -1, -2).add(0, 0, 0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel1, -1, 345, Short.MAX_VALUE).add((Component)this.jScrollPaneMainReport, -1, 345, Short.MAX_VALUE)).add(0, 0, 0)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jPanel1, -2, -1, -2).add(0, 0, 0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel2, -1, 270, Short.MAX_VALUE).add((Component)this.jScrollPaneMainReport, -1, 270, Short.MAX_VALUE)).add(0, 0, 0)));
    }

    public void addJasperDesignObserver(JasperDesignObserver jdo) {
        this.observers.add(jdo);
    }

    public void removeJasperDesignObserver(JasperDesignObserver jdo) {
        this.observers.remove(jdo);
    }

    public ReportObjectScene getScene() {
        return this.scene;
    }

    public void setScene(ReportObjectScene scene) {
        this.scene = scene;
    }

    public static interface JasperDesignObserver {
        public void jasperDesignAvailable(JasperDesign var1);
    }
}

