/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer;

import com.jaspersoft.ireport.JrxmlDataObject;
import com.jaspersoft.ireport.designer.JrxmlPreviewView;
import com.jaspersoft.ireport.designer.JrxmlTextView;
import com.jaspersoft.ireport.designer.JrxmlVisualView;
import java.io.IOException;
import java.util.logging.Logger;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.xml.JRXmlWriter;
import org.netbeans.core.spi.multiview.MultiViewDescription;
import org.netbeans.core.spi.multiview.MultiViewFactory;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.SaveAsCapable;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DataEditorSupport;
import org.openide.util.Lookup;
import org.openide.util.Task;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class JrxmlEditorSupport
extends DataEditorSupport
implements OpenCookie,
EditorCookie,
EditCookie,
SaveAsCapable {
    private static Logger LOG = Logger.getLogger(JrxmlEditorSupport.class.getName());
    private InstanceContent specialNodeLookupIC = null;
    private Lookup specialNodeLookup = null;
    private final SaveCookie saveCookie = new SaveCookie(){

        public void save() throws IOException {
            JrxmlEditorSupport.this.saveDocument();
        }
    };
    final MultiViewDescription[] descriptions = new MultiViewDescription[]{new JrxmlVisualView(this), new JrxmlTextView(this), new JrxmlPreviewView(this)};
    private JasperDesign currentModel = null;

    protected Task reloadDocument() {
        ((JrxmlVisualView)this.descriptions[0]).refreshModel();
        return super.reloadDocument();
    }

    public MultiViewDescription[] getDescriptions() {
        return this.descriptions;
    }

    private JrxmlEditorSupport(JrxmlDataObject obj) {
        super((DataObject)obj, (CloneableEditorSupport.Env)new JrxmlEnv(obj));
        this.specialNodeLookupIC = new InstanceContent();
        this.specialNodeLookup = new AbstractLookup((AbstractLookup.Content)this.specialNodeLookupIC);
    }

    public static JrxmlEditorSupport create(JrxmlDataObject obj) {
        JrxmlEditorSupport ed = new JrxmlEditorSupport(obj);
        ed.setMIMEType("text/xml");
        return ed;
    }

    protected CloneableEditorSupport.Pane createPane() {
        return (CloneableEditorSupport.Pane)MultiViewFactory.createCloneableMultiView((MultiViewDescription[])this.descriptions, (MultiViewDescription)this.descriptions[0]);
    }

    protected boolean notifyModified() {
        boolean retValue = super.notifyModified();
        if (retValue) {
            JrxmlDataObject obj = (JrxmlDataObject)this.getDataObject();
            if (obj.getCookie(SaveCookie.class) == null) {
                obj.getIc().add((Object)this.saveCookie);
                this.specialNodeLookupIC.add((Object)this.saveCookie);
                obj.setModified(true);
            }
            ((JrxmlPreviewView)this.descriptions[2]).setNeedRefresh(true);
        }
        return retValue;
    }

    protected void notifyUnmodified() {
        super.notifyUnmodified();
        JrxmlDataObject obj = (JrxmlDataObject)this.getDataObject();
        SaveCookie cookie = obj.getCookie(SaveCookie.class);
        if (cookie != null && cookie.equals(this.saveCookie)) {
            obj.getIc().remove((Object)this.saveCookie);
            this.specialNodeLookupIC.remove((Object)this.saveCookie);
            obj.setModified(false);
        }
    }

    public DataEditorSupport.Env getEnv() {
        return (DataEditorSupport.Env)this.env;
    }

    public void saveDocument() throws IOException {
        if (this.getCurrentModel() != null) {
            JasperDesign jd = this.getCurrentModel();
            try {
                String content = JRXmlWriter.writeReport((JRReport)jd, (String)"UTF8");
                this.getDocument().remove(0, this.getDocument().getLength());
                this.getDocument().insertString(0, content, null);
                ((JrxmlVisualView)this.descriptions[0]).setNeedModelRefresh(false);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        super.saveDocument();
    }

    public Lookup getSpecialNodeLookup() {
        return this.specialNodeLookup;
    }

    public void setSpecialNodeLookup(Lookup specialNodeLookup) {
        this.specialNodeLookup = specialNodeLookup;
    }

    public JasperDesign getCurrentModel() {
        return this.currentModel;
    }

    public void setCurrentModel(JasperDesign currentModel) {
        this.currentModel = currentModel;
    }

    public static final class JrxmlEnv
    extends DataEditorSupport.Env {
        public JrxmlEnv(JrxmlDataObject obj) {
            super((DataObject)obj);
        }

        protected FileObject getFile() {
            return super.getDataObject().getPrimaryFile();
        }

        protected FileLock takeLock() throws IOException {
            return ((JrxmlDataObject)super.getDataObject()).getPrimaryEntry().takeLock();
        }
    }
}

