/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.web.util;

import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.export.HtmlFont;
import net.sf.jasperreports.engine.export.HtmlResourceHandler;

class FontHtmlResourceHandler
implements HtmlResourceHandler {
    private String basePath;
    private HtmlFont htmlFont;
    private Map<String, String> fontFaceIds;
    private byte[] fontCss;

    protected FontHtmlResourceHandler(String basePath, HtmlFont htmlFont) {
        this.basePath = basePath;
        this.htmlFont = htmlFont;
        this.fontFaceIds = new HashMap<String, String>();
        this.fontFaceIds.put(String.valueOf(htmlFont.getId()) + ".ttf", htmlFont.getTtf());
        this.fontFaceIds.put(String.valueOf(htmlFont.getId()) + ".eot", htmlFont.getEot());
        this.fontFaceIds.put(String.valueOf(htmlFont.getId()) + ".woff", htmlFont.getWoff());
        this.fontFaceIds.put(String.valueOf(htmlFont.getId()) + ".svg", htmlFont.getSvg());
    }

    @Override
    public String getResourcePath(String id) {
        if (this.fontFaceIds.containsKey(id)) {
            return String.valueOf(this.basePath) + this.fontFaceIds.get(id);
        }
        return String.valueOf(this.basePath) + id;
    }

    @Override
    public void handleResource(String id, byte[] data) {
        if (id.equals(this.htmlFont.getId())) {
            this.fontCss = data;
        }
    }

    protected byte[] getFontCss() {
        return this.fontCss;
    }
}

