/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.view.save;

import java.io.File;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.JRXmlExporter;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleXmlExporterOutput;
import net.sf.jasperreports.view.JRSaveContributor;

public class JREmbeddedImagesXmlSaveContributor
extends JRSaveContributor {
    private static final String EXTENSION_XML = ".xml";
    private static final String EXTENSION_JRPXML = ".jrpxml";

    public JREmbeddedImagesXmlSaveContributor(Locale locale, ResourceBundle resBundle) {
        super(locale, resBundle);
    }

    public JREmbeddedImagesXmlSaveContributor(JasperReportsContext jasperReportsContext, Locale locale, ResourceBundle resBundle) {
        super(jasperReportsContext, locale, resBundle);
    }

    @Override
    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        String name = file.getName().toLowerCase();
        return name.endsWith(EXTENSION_XML) || name.endsWith(EXTENSION_JRPXML);
    }

    @Override
    public String getDescription() {
        return this.getBundleString("file.desc.xml.embedded.images");
    }

    @Override
    public void save(JasperPrint jasperPrint, File file) throws JRException {
        if (!file.getName().toLowerCase().endsWith(EXTENSION_XML) && !file.getName().toLowerCase().endsWith(EXTENSION_JRPXML)) {
            file = new File(String.valueOf(file.getAbsolutePath()) + EXTENSION_JRPXML);
        }
        if (!file.exists() || JOptionPane.showConfirmDialog(null, MessageFormat.format(this.getBundleString("file.exists"), file.getName()), this.getBundleString("save"), 2) == 0) {
            JRXmlExporter exporter = new JRXmlExporter(this.getJasperReportsContext());
            exporter.setExporterInput(new SimpleExporterInput(jasperPrint));
            SimpleXmlExporterOutput output = new SimpleXmlExporterOutput(file);
            output.setEmbeddingImages(true);
            exporter.setExporterOutput(output);
            exporter.exportReport();
        }
    }
}

