/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRVirtualizable;
import net.sf.jasperreports.engine.fill.JRAbstractLRUVirtualizer;

public class JRGzipVirtualizer
extends JRAbstractLRUVirtualizer {
    private final Map<String, byte[]> zippedData = Collections.synchronizedMap(new HashMap());

    public JRGzipVirtualizer(int maxSize) {
        super(maxSize);
    }

    @Override
    protected void dispose(String virtualId) {
        this.zippedData.remove(virtualId);
    }

    @Override
    protected void pageOut(JRVirtualizable o) throws IOException {
        if (!this.zippedData.containsKey(o.getUID())) {
            DeflaterOutputStream gos = null;
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream(3000);
                gos = new GZIPOutputStream(baos);
                this.writeData(o, gos);
                ((GZIPOutputStream)gos).finish();
                gos.flush();
                byte[] data = baos.toByteArray();
                this.zippedData.put(o.getUID(), data);
            }
            finally {
                if (gos != null) {
                    gos.close();
                }
            }
        } else if (!this.isReadOnly(o)) {
            throw new IllegalStateException("Cannot virtualize data because the data for object UID \"" + o.getUID() + "\" already exists.");
        }
    }

    @Override
    protected void pageIn(JRVirtualizable o) throws IOException {
        GZIPInputStream gis = null;
        try {
            byte[] data = this.zippedData.get(o.getUID());
            if (data == null) {
                throw new JRRuntimeException("No data found for object with UID " + o.getUID());
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            gis = new GZIPInputStream(bais);
            this.readData(o, gis);
        }
        finally {
            if (gis != null) {
                gis.close();
            }
        }
        if (!this.isReadOnly(o)) {
            this.zippedData.remove(o.getUID());
        }
    }

    @Override
    public void cleanup() {
        this.zippedData.clear();
        this.reset();
    }
}

