/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.ooxml;

import java.awt.Color;
import java.awt.font.TextAttribute;
import java.io.Writer;
import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.base.JRBasePrintText;
import net.sf.jasperreports.engine.export.ooxml.BaseHelper;
import net.sf.jasperreports.engine.fonts.FontFamily;
import net.sf.jasperreports.engine.fonts.FontInfo;
import net.sf.jasperreports.engine.fonts.FontUtil;
import net.sf.jasperreports.engine.type.ColorEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.util.JRColorUtil;
import net.sf.jasperreports.engine.util.JRStringUtil;

public class DocxRunHelper
extends BaseHelper {
    private String exporterKey;

    public DocxRunHelper(JasperReportsContext jasperReportsContext, Writer writer, String exporterKey) {
        super(jasperReportsContext, writer);
        this.exporterKey = exporterKey;
    }

    public void export(JRStyle style, Map<AttributedCharacterIterator.Attribute, Object> attributes, String text, Locale locale, boolean hiddenText, String invalidCharReplacement, Color backcolor) {
        if (text != null) {
            this.write("      <w:r>\n");
            boolean highlightText = backcolor == null || !backcolor.equals(attributes.get(TextAttribute.BACKGROUND));
            this.exportProps(this.getAttributes(style), attributes, locale, hiddenText, highlightText);
            StringTokenizer tkzer = new StringTokenizer(text, "\n", true);
            while (tkzer.hasMoreTokens()) {
                String token = tkzer.nextToken();
                if ("\n".equals(token)) {
                    this.write("<w:br/>");
                    continue;
                }
                this.write("<w:t xml:space=\"preserve\">");
                this.write(JRStringUtil.xmlEncode(token, invalidCharReplacement));
                this.write("</w:t>\n");
            }
            this.write("      </w:r>\n");
        }
    }

    public void exportProps(JRStyle style, Locale locale) {
        this.exportProps(this.getAttributes(style.getStyle()), this.getAttributes(style), locale, false, false);
    }

    public void exportProps(Map<AttributedCharacterIterator.Attribute, Object> parentAttrs, Map<AttributedCharacterIterator.Attribute, Object> attrs, Locale locale, boolean hiddenText, boolean highlightText) {
        this.write("       <w:rPr>\n");
        Object value = attrs.get(TextAttribute.FAMILY);
        Object oldValue = parentAttrs.get(TextAttribute.FAMILY);
        if (value != null && !value.equals(oldValue)) {
            FontFamily family;
            String exportFont;
            String fontFamilyAttr;
            String fontFamily = fontFamilyAttr = (String)value;
            FontInfo fontInfo = FontUtil.getInstance(this.jasperReportsContext).getFontInfo(fontFamilyAttr, locale);
            if (fontInfo != null && (exportFont = (family = fontInfo.getFontFamily()).getExportFont(this.exporterKey)) != null) {
                fontFamily = exportFont;
            }
            this.write("        <w:rFonts w:ascii=\"" + fontFamily + "\" w:hAnsi=\"" + fontFamily + "\" w:eastAsia=\"" + fontFamily + "\" w:cs=\"" + fontFamily + "\" />\n");
        }
        value = attrs.get(TextAttribute.FOREGROUND);
        oldValue = parentAttrs.get(TextAttribute.FOREGROUND);
        if (value != null && !value.equals(oldValue)) {
            this.write("        <w:color w:val=\"" + JRColorUtil.getColorHexa((Color)value) + "\" />\n");
        }
        if (highlightText && (value = attrs.get(TextAttribute.BACKGROUND)) != null && ColorEnum.getByColor((Color)value) != null) {
            this.write("        <w:highlight w:val=\"" + ColorEnum.getByColor((Color)value).getName() + "\" />\n");
        }
        value = attrs.get(TextAttribute.SIZE);
        oldValue = parentAttrs.get(TextAttribute.SIZE);
        if (value != null && !value.equals(oldValue)) {
            float fontSize = ((Float)value).floatValue();
            fontSize = fontSize == 0.0f ? 0.5f : fontSize;
            this.write("        <w:sz w:val=\"" + (int)(2.0f * fontSize) + "\" />\n");
        }
        value = attrs.get(TextAttribute.WEIGHT);
        oldValue = parentAttrs.get(TextAttribute.WEIGHT);
        if (value != null && !value.equals(oldValue)) {
            this.write("        <w:b w:val=\"" + value.equals(TextAttribute.WEIGHT_BOLD) + "\"/>\n");
        }
        value = attrs.get(TextAttribute.POSTURE);
        oldValue = parentAttrs.get(TextAttribute.POSTURE);
        if (value != null && !value.equals(oldValue)) {
            this.write("        <w:i w:val=\"" + value.equals(TextAttribute.POSTURE_OBLIQUE) + "\"/>\n");
        }
        value = attrs.get(TextAttribute.UNDERLINE);
        oldValue = parentAttrs.get(TextAttribute.UNDERLINE);
        if (value == null && oldValue != null || value != null && !value.equals(oldValue)) {
            this.write("        <w:u w:val=\"" + (value == null ? "none" : "single") + "\"/>\n");
        }
        value = attrs.get(TextAttribute.STRIKETHROUGH);
        oldValue = parentAttrs.get(TextAttribute.STRIKETHROUGH);
        if (value == null && oldValue != null || value != null && !value.equals(oldValue)) {
            this.write("        <w:strike w:val=\"" + (value != null) + "\"/>\n");
        }
        if (TextAttribute.SUPERSCRIPT_SUPER.equals(value = attrs.get(TextAttribute.SUPERSCRIPT))) {
            this.write("        <w:vertAlign w:val=\"superscript\" />\n");
        } else if (TextAttribute.SUPERSCRIPT_SUB.equals(value)) {
            this.write("        <w:vertAlign w:val=\"subscript\" />\n");
        }
        if (hiddenText) {
            this.write("        <w:vanish/>\n");
        }
        this.write("       </w:rPr>\n");
    }

    private Map<AttributedCharacterIterator.Attribute, Object> getAttributes(JRStyle style) {
        JRBasePrintText text = new JRBasePrintText(null);
        text.setStyle(style);
        HashMap<AttributedCharacterIterator.Attribute, Object> styledTextAttributes = new HashMap<AttributedCharacterIterator.Attribute, Object>();
        FontUtil.getInstance(this.jasperReportsContext).getAttributesWithoutAwtFont(styledTextAttributes, text);
        styledTextAttributes.put(TextAttribute.FOREGROUND, text.getForecolor());
        if (text.getModeValue() == ModeEnum.OPAQUE) {
            styledTextAttributes.put(TextAttribute.BACKGROUND, text.getBackcolor());
        }
        return styledTextAttributes;
    }
}

