/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.draw;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.Collection;
import java.util.LinkedList;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.AwtTextRenderer;
import net.sf.jasperreports.engine.export.ExporterFilter;
import net.sf.jasperreports.engine.export.GenericElementGraphics2DHandler;
import net.sf.jasperreports.engine.export.GenericElementHandlerEnviroment;
import net.sf.jasperreports.engine.export.JRGraphics2DExporterContext;
import net.sf.jasperreports.engine.export.draw.ElementDrawer;
import net.sf.jasperreports.engine.export.draw.Offset;
import net.sf.jasperreports.engine.export.draw.PrintDrawVisitor;
import net.sf.jasperreports.engine.export.draw.TextDrawer;
import net.sf.jasperreports.engine.type.ModeEnum;

public class FrameDrawer
extends ElementDrawer<JRPrintFrame> {
    private static final int ELEMENT_RECTANGLE_PADDING = 3;
    private ExporterFilter filter;
    private Graphics2D grx;
    private LinkedList<Offset> elementOffsetStack = new LinkedList();
    private Offset elementOffset;
    private boolean isClip;
    private final PrintDrawVisitor drawVisitor;
    private JRGraphics2DExporterContext exporterContext;

    public FrameDrawer(ExporterFilter filter, AwtTextRenderer textRenderer) {
        this(DefaultJasperReportsContext.getInstance(), filter, textRenderer);
    }

    public FrameDrawer(JasperReportsContext jasperReportsContext, ExporterFilter filter, AwtTextRenderer textRenderer) {
        super(jasperReportsContext);
        this.filter = filter;
        this.drawVisitor = new PrintDrawVisitor(jasperReportsContext);
        this.drawVisitor.setTextDrawer(new TextDrawer(jasperReportsContext, textRenderer));
        this.drawVisitor.setFrameDrawer(this);
    }

    public FrameDrawer(JRGraphics2DExporterContext exporterContext, ExporterFilter filter, AwtTextRenderer textRenderer) {
        this(exporterContext.getJasperReportsContext(), filter, textRenderer);
        this.exporterContext = exporterContext;
    }

    public void setClip(boolean isClip) {
        this.isClip = isClip;
    }

    @Override
    public void draw(Graphics2D grx, JRPrintFrame frame, int offsetX, int offsetY) throws JRException {
        this.setGraphics(grx);
        Shape oldClipShape = null;
        if (this.isClip) {
            oldClipShape = grx.getClip();
            grx.clip(new Rectangle(frame.getX() + offsetX, frame.getY() + offsetY, frame.getWidth(), frame.getHeight()));
        }
        if (frame.getModeValue() == ModeEnum.OPAQUE) {
            grx.setColor(frame.getBackcolor());
            grx.fillRect(frame.getX() + offsetX, frame.getY() + offsetY, frame.getWidth(), frame.getHeight());
        }
        grx.setColor(frame.getForecolor());
        this.setFrameElementsOffset(frame, offsetX, offsetY);
        try {
            this.draw(frame.getElements());
        }
        finally {
            if (this.isClip) {
                grx.setClip(oldClipShape);
            }
            this.restoreElementOffsets();
        }
        this.drawBox(grx, frame.getLineBox(), frame, offsetX, offsetY);
    }

    @Override
    public void draw(Graphics2D grx, Collection<JRPrintElement> elements, int offsetX, int offsetY) throws JRException {
        this.setGraphics(grx);
        this.setElementOffsets(offsetX, offsetY);
        try {
            this.draw(elements);
        }
        finally {
            this.restoreElementOffsets();
        }
    }

    protected void setGraphics(Graphics2D grx) {
        this.grx = grx;
        this.drawVisitor.setGraphics2D(grx);
    }

    private void draw(Collection<JRPrintElement> elements) throws JRException {
        if (elements != null && elements.size() > 0) {
            Shape clipArea = this.grx.getClip();
            for (JRPrintElement element : elements) {
                boolean isGenericElementToExport;
                boolean isGenericElement = element instanceof JRGenericPrintElement;
                JRGenericPrintElement genericElement = isGenericElement ? (JRGenericPrintElement)element : null;
                GenericElementGraphics2DHandler handler = isGenericElement ? (GenericElementGraphics2DHandler)GenericElementHandlerEnviroment.getInstance(this.getJasperReportsContext()).getElementHandler(genericElement.getGenericType(), "net.sf.jasperreports.graphics2d") : null;
                boolean bl = isGenericElementToExport = isGenericElement && handler != null && handler.toExport(genericElement);
                if (this.filter != null && !this.filter.isToExport(element) || !clipArea.intersects(element.getX() + this.elementOffset.getX() - 3, element.getY() + this.elementOffset.getY() - 3, element.getWidth() + 6, element.getHeight() + 6)) continue;
                if (isGenericElementToExport) {
                    handler.exportElement(this.exporterContext, genericElement, this.grx, this.elementOffset);
                    continue;
                }
                element.accept(this.drawVisitor, this.elementOffset);
            }
        }
    }

    private void setFrameElementsOffset(JRPrintFrame frame, int offsetX, int offsetY) {
        this.setElementOffsets(offsetX + frame.getX() + frame.getLineBox().getLeftPadding(), offsetY + frame.getY() + frame.getLineBox().getTopPadding());
    }

    private void setElementOffsets(int offsetX, int offsetY) {
        this.elementOffsetStack.addLast(this.elementOffset);
        this.elementOffset = new Offset(offsetX, offsetY);
    }

    private void restoreElementOffsets() {
        this.elementOffset = this.elementOffsetStack.removeLast();
    }

    public JRGraphics2DExporterContext getExporterContext() {
        return this.exporterContext;
    }

    public PrintDrawVisitor getDrawVisitor() {
        return this.drawVisitor;
    }
}

