/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.convert;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JRReportTemplate;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRSection;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRStyleContainer;
import net.sf.jasperreports.engine.JRTemplate;
import net.sf.jasperreports.engine.JRTemplateReference;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.base.JRBasePrintFrame;
import net.sf.jasperreports.engine.base.JRBasePrintPage;
import net.sf.jasperreports.engine.convert.ConvertVisitor;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.type.LineStyleEnum;
import net.sf.jasperreports.engine.type.PrintOrderEnum;
import net.sf.jasperreports.engine.type.RunDirectionEnum;
import net.sf.jasperreports.engine.util.JRExpressionUtil;
import net.sf.jasperreports.engine.xml.JRXmlTemplateLoader;
import org.apache.commons.collections.map.LinkedMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReportConverter {
    private static final Log log = LogFactory.getLog(ReportConverter.class);
    public static final Color GRID_LINE_COLOR = new Color(170, 170, 255);
    private final JasperReportsContext jasperReportsContext;
    private final JRReport report;
    private JasperPrint jasperPrint;
    private JRPrintPage page;
    int pageWidth;
    private int offsetY;
    private int upColumnHeader;
    private int downColumnHeader;
    private int upDetails;
    private int downDetails;
    private int upColumnFooter;
    private int downColumnFooter;
    private List<JRPrintElement> pageElements = new ArrayList<JRPrintElement>();
    protected Map<String, JRStyle> stylesMap;

    public ReportConverter(JasperReportsContext jasperReportsContext, JRReport report, boolean ignoreContent) {
        this.jasperReportsContext = jasperReportsContext;
        this.report = report;
        if (report instanceof JasperDesign) {
            ((JasperDesign)report).preprocess();
        }
        this.convert(ignoreContent);
    }

    public ReportConverter(JRReport report, boolean ignoreContent) {
        this(DefaultJasperReportsContext.getInstance(), report, ignoreContent);
    }

    protected void convert(boolean ignoreContent) {
        this.jasperPrint = new JasperPrint();
        this.jasperPrint.setFormatFactoryClass(this.report.getFormatFactoryClass());
        this.jasperPrint.setName(this.report.getName());
        this.jasperPrint.setOrientation(this.report.getOrientationValue());
        this.jasperPrint.setPageWidth(this.report.getPageWidth());
        this.jasperPrint.setPageHeight(this.report.getPageHeight());
        this.jasperPrint.setTopMargin(this.report.getTopMargin());
        this.jasperPrint.setLeftMargin(this.report.getLeftMargin());
        this.jasperPrint.setBottomMargin(this.report.getBottomMargin());
        this.jasperPrint.setRightMargin(this.report.getRightMargin());
        JRPropertiesUtil.getInstance(this.jasperReportsContext).transferProperties(this.report, (JRPropertiesHolder)this.jasperPrint, "net.sf.jasperreports.print.transfer.");
        this.setStyles(this.report);
        if (!ignoreContent) {
            int i;
            this.pageWidth = this.report.getPageWidth();
            this.page = new JRBasePrintPage();
            this.offsetY = this.report.getTopMargin();
            this.addBand(this.report.getBackground());
            this.addBand(this.report.getTitle());
            this.addBand(this.report.getPageHeader());
            this.upColumnHeader = this.offsetY;
            this.addBand(this.report.getColumnHeader(), true);
            this.downColumnHeader = this.offsetY;
            boolean isColumnGroupBands = this.report.getPrintOrderValue() == PrintOrderEnum.VERTICAL;
            JRGroup[] groups = this.report.getGroups();
            if (groups != null) {
                i = 0;
                while (i < groups.length) {
                    this.addSection(groups[i].getGroupHeaderSection(), isColumnGroupBands);
                    ++i;
                }
            }
            this.upDetails = this.offsetY;
            this.addSection(this.report.getDetailSection(), true);
            this.downDetails = this.offsetY;
            if (groups != null) {
                i = 0;
                while (i < groups.length) {
                    this.addSection(groups[i].getGroupFooterSection(), isColumnGroupBands);
                    ++i;
                }
            }
            this.upColumnFooter = this.offsetY;
            this.addBand(this.report.getColumnFooter(), true);
            this.downColumnFooter = this.offsetY;
            this.addBand(this.report.getPageFooter());
            this.addBand(this.report.getLastPageFooter());
            this.addBand(this.report.getSummary());
            this.addBand(this.report.getNoData());
            this.jasperPrint.setPageHeight(this.offsetY + this.report.getBottomMargin());
            int colX = this.report.getLeftMargin();
            int i2 = 0;
            while (i2 < this.report.getColumnCount()) {
                this.addColumnSeparator(colX);
                this.addColumnSeparator(colX += this.report.getColumnWidth());
                colX += this.report.getColumnSpacing();
                ++i2;
            }
            this.addHorizontalGridLine(0, this.report.getTopMargin(), this.pageWidth);
            this.addHorizontalGridLine(0, this.offsetY, this.pageWidth);
            this.addVerticalGridLine(this.report.getLeftMargin(), 0, this.jasperPrint.getPageHeight());
            this.addVerticalGridLine(this.pageWidth - this.report.getRightMargin(), 0, this.jasperPrint.getPageHeight());
            this.page.setElements(this.pageElements);
            this.jasperPrint.addPage(this.page);
        }
    }

    protected void setStyles(JRReport report) {
        this.stylesMap = new LinkedMap();
        this.loadReportStyles(report);
        try {
            for (JRStyle style : this.stylesMap.values()) {
                this.jasperPrint.addStyle(style);
            }
        }
        catch (JRException e) {
            throw new JRRuntimeException(e);
        }
        JRStyle reportDefault = report.getDefaultStyle();
        JRStyle printDefault = null;
        if (reportDefault == null) {
            for (JRStyle style : this.stylesMap.values()) {
                if (!style.isDefault()) continue;
                printDefault = style;
            }
        } else {
            printDefault = reportDefault;
        }
        if (printDefault != null) {
            this.jasperPrint.setDefaultStyle(printDefault);
        }
    }

    protected void loadReportStyles(JRReport report) {
        JRReportTemplate[] templates = report.getTemplates();
        if (templates != null) {
            HashSet<String> loadedLocations = new HashSet<String>();
            int i = 0;
            while (i < templates.length) {
                this.loadReportTemplateStyles(templates[i], loadedLocations);
                ++i;
            }
        }
        this.collectStyles(report.getStyles());
    }

    protected void loadReportTemplateStyles(JRReportTemplate template, Set<String> loadedLocations) {
        JRExpression sourceExpression = template.getSourceExpression();
        if (sourceExpression != null) {
            String location = JRExpressionUtil.getSimpleExpressionText(sourceExpression);
            if (location == null) {
                log.warn((Object)("Template source expression " + sourceExpression.getText() + "cannot be evaluated; some styles might remain unresolved."));
            } else {
                HashSet<String> parentLocations = new HashSet<String>();
                this.loadTemplateStyles(location, loadedLocations, parentLocations);
            }
        }
    }

    protected void loadTemplateStyles(String location, Set<String> loadedLocations, Set<String> parentLocations) {
        JRTemplate template;
        if (!parentLocations.add(location)) {
            throw new JRRuntimeException("Circular dependency found for template at location " + location);
        }
        if (!loadedLocations.add(location)) {
            return;
        }
        try {
            template = JRXmlTemplateLoader.getInstance(this.getJasperReportsContext()).loadTemplate(location);
        }
        catch (Exception e) {
            log.warn((Object)("Could not load template from location " + location + "; some styles might remain unresolved."));
            return;
        }
        JRTemplateReference[] includedTemplates = template.getIncludedTemplates();
        if (includedTemplates != null) {
            int i = 0;
            while (i < includedTemplates.length) {
                JRTemplateReference reference = includedTemplates[i];
                this.loadTemplateStyles(reference.getLocation(), loadedLocations, parentLocations);
                ++i;
            }
        }
        this.collectStyles(template.getStyles());
    }

    protected void collectStyles(JRStyle[] styles) {
        if (styles != null) {
            int i = 0;
            while (i < styles.length) {
                JRStyle style = styles[i];
                this.stylesMap.put(style.getName(), style);
                ++i;
            }
        }
    }

    private void addSection(JRSection section, boolean isColumnSection) {
        JRBand[] bands;
        if (section != null && (bands = section.getBands()) != null && bands.length > 0) {
            int i = 0;
            while (i < bands.length) {
                this.addBand(bands[i], isColumnSection);
                ++i;
            }
        }
    }

    private void addBand(JRBand band) {
        this.addBand(band, false);
    }

    private void addBand(JRBand band, boolean isColumnBand) {
        if (band != null) {
            JRBasePrintFrame frame = new JRBasePrintFrame(null);
            frame.setX(isColumnBand && this.report.getColumnDirection() == RunDirectionEnum.RTL ? this.report.getPageWidth() - this.report.getRightMargin() - this.report.getColumnWidth() : this.report.getLeftMargin());
            frame.setY(this.offsetY);
            frame.setWidth(isColumnBand ? this.report.getColumnWidth() : this.report.getPageWidth() - this.report.getLeftMargin() - this.report.getRightMargin());
            frame.setHeight(band.getHeight());
            band.visit(new ConvertVisitor(this, frame));
            this.pageElements.add(frame);
            this.offsetY += band.getHeight();
            this.addBandSeparator(this.offsetY);
        }
    }

    private void addBandSeparator(int bandY) {
        this.addHorizontalGridLine(0, bandY, this.pageWidth);
    }

    private void addColumnSeparator(int colX) {
        if (this.report.getPrintOrderValue() == PrintOrderEnum.HORIZONTAL) {
            if (this.downColumnHeader > this.upColumnHeader) {
                this.addVerticalGridLine(colX, this.upColumnHeader, this.downColumnHeader - this.upColumnHeader);
            }
            if (this.downDetails > this.upDetails) {
                this.addVerticalGridLine(colX, this.upDetails, this.downDetails - this.upDetails);
            }
            if (this.downColumnFooter > this.upColumnFooter) {
                this.addVerticalGridLine(colX, this.upColumnFooter, this.downColumnFooter - this.upColumnFooter);
            }
        } else if (this.downColumnFooter > this.upColumnHeader) {
            this.addVerticalGridLine(colX, this.upColumnHeader, this.downColumnFooter - this.upColumnHeader);
        }
    }

    private void addHorizontalGridLine(int x, int y, int width) {
        JRBasePrintFrame printFrame = new JRBasePrintFrame(this.getDefaultStyleProvider());
        printFrame.setX(x);
        printFrame.setY(y);
        printFrame.setWidth(width);
        printFrame.setHeight(1);
        printFrame.getLineBox().getPen().setLineWidth(0.0f);
        printFrame.getLineBox().getPen().setLineStyle(LineStyleEnum.SOLID);
        printFrame.getLineBox().getTopPen().setLineWidth(0.1f);
        printFrame.getLineBox().getTopPen().setLineStyle(LineStyleEnum.DASHED);
        printFrame.getLineBox().getTopPen().setLineColor(GRID_LINE_COLOR);
        this.pageElements.add(0, printFrame);
    }

    private void addVerticalGridLine(int x, int y, int height) {
        JRBasePrintFrame printFrame = new JRBasePrintFrame(this.getDefaultStyleProvider());
        printFrame.setX(x);
        printFrame.setY(y);
        printFrame.setWidth(1);
        printFrame.setHeight(height);
        printFrame.getLineBox().getPen().setLineWidth(0.0f);
        printFrame.getLineBox().getPen().setLineStyle(LineStyleEnum.SOLID);
        printFrame.getLineBox().getLeftPen().setLineWidth(0.1f);
        printFrame.getLineBox().getLeftPen().setLineStyle(LineStyleEnum.DASHED);
        printFrame.getLineBox().getLeftPen().setLineColor(GRID_LINE_COLOR);
        this.pageElements.add(0, printFrame);
    }

    public JRStyle resolveStyle(JRStyleContainer originalContainer) {
        JRStyle style;
        JRStyle originalStyle = originalContainer.getStyle();
        String nameReference = originalContainer.getStyleNameReference();
        if (originalStyle != null) {
            style = originalStyle;
        } else if (nameReference != null) {
            style = this.stylesMap.get(nameReference);
            if (style == null) {
                log.warn((Object)("Style " + nameReference + " could not be resolved."));
            }
        } else {
            style = null;
        }
        return style;
    }

    public JasperReportsContext getJasperReportsContext() {
        return this.jasperReportsContext;
    }

    public JRReport getReport() {
        return this.report;
    }

    public JasperPrint getJasperPrint() {
        return this.jasperPrint;
    }

    public JRDefaultStyleProvider getDefaultStyleProvider() {
        return this.report;
    }

    public void copyBaseAttributes(JRElement source, JRPrintElement converted) {
        converted.setUUID(source.getUUID());
        converted.setX(source.getX());
        converted.setY(source.getY());
        converted.setWidth(source.getWidth());
        converted.setHeight(source.getHeight());
        converted.setBackcolor(source.getOwnBackcolor());
        converted.setForecolor(source.getOwnForecolor());
        converted.setMode(source.getOwnModeValue());
        converted.setStyle(this.resolveStyle(source));
    }
}

