/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.convert;

import java.util.List;
import net.sf.jasperreports.crosstabs.JRCrosstab;
import net.sf.jasperreports.engine.JRBoxContainer;
import net.sf.jasperreports.engine.JRBreak;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRComponentElement;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JREllipse;
import net.sf.jasperreports.engine.JRFrame;
import net.sf.jasperreports.engine.JRGenericElement;
import net.sf.jasperreports.engine.JRImage;
import net.sf.jasperreports.engine.JRLine;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintGraphicElement;
import net.sf.jasperreports.engine.JRRectangle;
import net.sf.jasperreports.engine.JRStaticText;
import net.sf.jasperreports.engine.JRSubreport;
import net.sf.jasperreports.engine.JRTextField;
import net.sf.jasperreports.engine.JRVisitable;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.base.JRBasePrintFrame;
import net.sf.jasperreports.engine.base.JRBasePrintRectangle;
import net.sf.jasperreports.engine.convert.ChartConverter;
import net.sf.jasperreports.engine.convert.ComponentElementConverter;
import net.sf.jasperreports.engine.convert.CrosstabConverter;
import net.sf.jasperreports.engine.convert.EllipseConverter;
import net.sf.jasperreports.engine.convert.FrameConverter;
import net.sf.jasperreports.engine.convert.GenericElementConverter;
import net.sf.jasperreports.engine.convert.ImageConverter;
import net.sf.jasperreports.engine.convert.LineConverter;
import net.sf.jasperreports.engine.convert.RectangleConverter;
import net.sf.jasperreports.engine.convert.ReportConverter;
import net.sf.jasperreports.engine.convert.StaticTextConverter;
import net.sf.jasperreports.engine.convert.SubreportConverter;
import net.sf.jasperreports.engine.convert.TextFieldConverter;
import net.sf.jasperreports.engine.type.LineStyleEnum;
import net.sf.jasperreports.engine.type.ModeEnum;

public class ConvertVisitor
implements JRVisitor {
    protected ReportConverter reportConverter;
    protected JRBasePrintFrame parentFrame;
    protected JRPrintElement printElement;

    public ConvertVisitor(ReportConverter reportConverter) {
        this(reportConverter, null);
    }

    public ConvertVisitor(ReportConverter reportConverter, JRBasePrintFrame parentFrame) {
        this.reportConverter = reportConverter;
        this.parentFrame = parentFrame;
    }

    public JRPrintElement getVisitPrintElement(JRVisitable visitable) {
        if (visitable != null) {
            visitable.visit(this);
            return this.printElement;
        }
        return null;
    }

    @Override
    public void visitBreak(JRBreak breakElement) {
    }

    @Override
    public void visitChart(JRChart chart) {
        JRPrintElement printImage = ChartConverter.getInstance().convert(this.reportConverter, chart);
        this.addElement(this.parentFrame, printImage);
        this.addContour(this.reportConverter, this.parentFrame, printImage);
    }

    @Override
    public void visitCrosstab(JRCrosstab crosstab) {
        JRPrintElement printFrame = CrosstabConverter.getInstance().convert(this.reportConverter, crosstab);
        this.addElement(this.parentFrame, printFrame);
        this.addContour(this.reportConverter, this.parentFrame, printFrame);
    }

    @Override
    public void visitElementGroup(JRElementGroup elementGroup) {
        List<JRChild> children = elementGroup.getChildren();
        if (children != null && children.size() > 0) {
            int i = 0;
            while (i < children.size()) {
                children.get(i).visit(this);
                ++i;
            }
        }
    }

    @Override
    public void visitEllipse(JREllipse ellipse) {
        this.addElement(this.parentFrame, EllipseConverter.getInstance().convert(this.reportConverter, ellipse));
    }

    @Override
    public void visitFrame(JRFrame frame) {
        JRPrintElement printFrame = FrameConverter.getInstance().convert(this.reportConverter, frame);
        this.addElement(this.parentFrame, printFrame);
        this.addContour(this.reportConverter, this.parentFrame, printFrame);
    }

    @Override
    public void visitImage(JRImage image) {
        JRPrintElement printImage = ImageConverter.getInstance().convert(this.reportConverter, image);
        this.addElement(this.parentFrame, printImage);
        this.addContour(this.reportConverter, this.parentFrame, printImage);
    }

    @Override
    public void visitLine(JRLine line) {
        this.addElement(this.parentFrame, LineConverter.getInstance().convert(this.reportConverter, line));
    }

    @Override
    public void visitRectangle(JRRectangle rectangle) {
        this.addElement(this.parentFrame, RectangleConverter.getInstance().convert(this.reportConverter, rectangle));
    }

    @Override
    public void visitStaticText(JRStaticText staticText) {
        JRPrintElement printText = StaticTextConverter.getInstance().convert(this.reportConverter, staticText);
        this.addElement(this.parentFrame, printText);
        this.addContour(this.reportConverter, this.parentFrame, printText);
    }

    @Override
    public void visitSubreport(JRSubreport subreport) {
        JRPrintElement printImage = SubreportConverter.getInstance().convert(this.reportConverter, subreport);
        this.addElement(this.parentFrame, printImage);
        this.addContour(this.reportConverter, this.parentFrame, printImage);
    }

    @Override
    public void visitTextField(JRTextField textField) {
        JRPrintElement printText = TextFieldConverter.getInstance().convert(this.reportConverter, textField);
        this.addElement(this.parentFrame, printText);
        this.addContour(this.reportConverter, this.parentFrame, printText);
    }

    protected void addElement(JRBasePrintFrame frame, JRPrintElement element) {
        this.printElement = element;
        if (frame != null) {
            frame.addElement(element);
        }
    }

    protected void addContour(ReportConverter reportConverter, JRBasePrintFrame frame, JRPrintElement element) {
        if (frame != null) {
            JRLineBox box;
            boolean hasContour = false;
            JRLineBox jRLineBox = box = element instanceof JRBoxContainer ? ((JRBoxContainer)((Object)element)).getLineBox() : null;
            if (box == null) {
                JRPrintGraphicElement graphicElement = element instanceof JRPrintGraphicElement ? (JRPrintGraphicElement)element : null;
                hasContour = graphicElement == null || graphicElement.getLinePen().getLineWidth().floatValue() <= 0.0f;
            } else {
                boolean bl = hasContour = box.getTopPen().getLineWidth().floatValue() <= 0.0f && box.getLeftPen().getLineWidth().floatValue() <= 0.0f && box.getRightPen().getLineWidth().floatValue() <= 0.0f && box.getBottomPen().getLineWidth().floatValue() <= 0.0f;
            }
            if (hasContour) {
                JRBasePrintRectangle rectangle = new JRBasePrintRectangle(reportConverter.getDefaultStyleProvider());
                rectangle.setUUID(element.getUUID());
                rectangle.setX(element.getX());
                rectangle.setY(element.getY());
                rectangle.setWidth(element.getWidth());
                rectangle.setHeight(element.getHeight());
                rectangle.getLinePen().setLineWidth(0.1f);
                rectangle.getLinePen().setLineStyle(LineStyleEnum.DASHED);
                rectangle.getLinePen().setLineColor(ReportConverter.GRID_LINE_COLOR);
                rectangle.setMode(ModeEnum.TRANSPARENT);
                frame.addElement(rectangle);
            }
        }
    }

    @Override
    public void visitComponentElement(JRComponentElement componentElement) {
        JRPrintElement image = ComponentElementConverter.getInstance().convert(this.reportConverter, componentElement);
        this.addElement(this.parentFrame, image);
        this.addContour(this.reportConverter, this.parentFrame, image);
    }

    @Override
    public void visitGenericElement(JRGenericElement element) {
        JRPrintElement image = GenericElementConverter.getInstance().convert(this.reportConverter, element);
        this.addElement(this.parentFrame, image);
        this.addContour(this.reportConverter, this.parentFrame, image);
    }
}

