/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine;

import java.awt.Image;
import java.io.InputStream;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.JRPrintServiceExporter;
import net.sf.jasperreports.engine.print.JRPrinterAWT;
import net.sf.jasperreports.engine.util.JRLoader;

public final class JasperPrintManager {
    private JasperReportsContext jasperReportsContext;
    public static final String PROPERTY_CHECK_AVAILABLE_PRINTERS = "net.sf.jasperreports.awt.check.available.printers";
    protected static final boolean unixSunJDK;

    static {
        boolean found = false;
        try {
            Class.forName("sun.print.UnixPrintServiceLookup");
            found = true;
        }
        catch (ClassNotFoundException e) {
            found = false;
        }
        unixSunJDK = found;
    }

    private JasperPrintManager(JasperReportsContext jasperReportsContext) {
        this.jasperReportsContext = jasperReportsContext;
    }

    private static JasperPrintManager getDefaultInstance() {
        return new JasperPrintManager(DefaultJasperReportsContext.getInstance());
    }

    public static JasperPrintManager getInstance(JasperReportsContext jasperReportsContext) {
        return new JasperPrintManager(jasperReportsContext);
    }

    public boolean print(String sourceFileName, boolean withPrintDialog) throws JRException {
        JasperPrint jasperPrint = (JasperPrint)JRLoader.loadObjectFromFile(sourceFileName);
        return this.print(jasperPrint, withPrintDialog);
    }

    public boolean print(InputStream inputStream, boolean withPrintDialog) throws JRException {
        JasperPrint jasperPrint = (JasperPrint)JRLoader.loadObject(inputStream);
        return this.print(jasperPrint, withPrintDialog);
    }

    public boolean print(JasperPrint jasperPrint, boolean withPrintDialog) throws JRException {
        boolean checkAvailablePrinters = JRPropertiesUtil.getInstance(this.jasperReportsContext).getBooleanProperty(jasperPrint, PROPERTY_CHECK_AVAILABLE_PRINTERS, true);
        if (checkAvailablePrinters && !unixSunJDK && !JRPrintServiceExporter.checkAvailablePrinters()) {
            throw new JRException("No printer available.");
        }
        return this.print(jasperPrint, 0, jasperPrint.getPages().size() - 1, withPrintDialog);
    }

    public boolean print(String sourceFileName, int pageIndex, boolean withPrintDialog) throws JRException {
        JasperPrint jasperPrint = (JasperPrint)JRLoader.loadObjectFromFile(sourceFileName);
        return this.print(jasperPrint, pageIndex, withPrintDialog);
    }

    public boolean print(InputStream inputStream, int pageIndex, boolean withPrintDialog) throws JRException {
        JasperPrint jasperPrint = (JasperPrint)JRLoader.loadObject(inputStream);
        return this.print(jasperPrint, pageIndex, withPrintDialog);
    }

    public boolean print(JasperPrint jasperPrint, int pageIndex, boolean withPrintDialog) throws JRException {
        return this.print(jasperPrint, pageIndex, pageIndex, withPrintDialog);
    }

    public boolean print(String sourceFileName, int firstPageIndex, int lastPageIndex, boolean withPrintDialog) throws JRException {
        JasperPrint jasperPrint = (JasperPrint)JRLoader.loadObjectFromFile(sourceFileName);
        return this.print(jasperPrint, firstPageIndex, lastPageIndex, withPrintDialog);
    }

    public boolean print(InputStream inputStream, int firstPageIndex, int lastPageIndex, boolean withPrintDialog) throws JRException {
        JasperPrint jasperPrint = (JasperPrint)JRLoader.loadObject(inputStream);
        return this.print(jasperPrint, firstPageIndex, lastPageIndex, withPrintDialog);
    }

    public boolean print(JasperPrint jasperPrint, int firstPageIndex, int lastPageIndex, boolean withPrintDialog) throws JRException {
        return new JRPrinterAWT(this.jasperReportsContext, jasperPrint).printPages(firstPageIndex, lastPageIndex, withPrintDialog);
    }

    public Image printToImage(String sourceFileName, int pageIndex, float zoom) throws JRException {
        JasperPrint jasperPrint = (JasperPrint)JRLoader.loadObjectFromFile(sourceFileName);
        return this.printToImage(jasperPrint, pageIndex, zoom);
    }

    public Image printToImage(InputStream inputStream, int pageIndex, float zoom) throws JRException {
        JasperPrint jasperPrint = (JasperPrint)JRLoader.loadObject(inputStream);
        return this.printToImage(jasperPrint, pageIndex, zoom);
    }

    public Image printToImage(JasperPrint jasperPrint, int pageIndex, float zoom) throws JRException {
        return new JRPrinterAWT(this.jasperReportsContext, jasperPrint).printPageToImage(pageIndex, zoom);
    }

    public static boolean printReport(String sourceFileName, boolean withPrintDialog) throws JRException {
        return JasperPrintManager.getDefaultInstance().print(sourceFileName, withPrintDialog);
    }

    public static boolean printReport(InputStream inputStream, boolean withPrintDialog) throws JRException {
        return JasperPrintManager.getDefaultInstance().print(inputStream, withPrintDialog);
    }

    public static boolean printReport(JasperPrint jasperPrint, boolean withPrintDialog) throws JRException {
        return JasperPrintManager.getDefaultInstance().print(jasperPrint, withPrintDialog);
    }

    public static boolean printPage(String sourceFileName, int pageIndex, boolean withPrintDialog) throws JRException {
        return JasperPrintManager.getDefaultInstance().print(sourceFileName, pageIndex, withPrintDialog);
    }

    public static boolean printPage(InputStream inputStream, int pageIndex, boolean withPrintDialog) throws JRException {
        return JasperPrintManager.getDefaultInstance().print(inputStream, pageIndex, withPrintDialog);
    }

    public static boolean printPage(JasperPrint jasperPrint, int pageIndex, boolean withPrintDialog) throws JRException {
        return JasperPrintManager.getDefaultInstance().print(jasperPrint, pageIndex, withPrintDialog);
    }

    public static boolean printPages(String sourceFileName, int firstPageIndex, int lastPageIndex, boolean withPrintDialog) throws JRException {
        return JasperPrintManager.getDefaultInstance().print(sourceFileName, firstPageIndex, lastPageIndex, withPrintDialog);
    }

    public static boolean printPages(InputStream inputStream, int firstPageIndex, int lastPageIndex, boolean withPrintDialog) throws JRException {
        return JasperPrintManager.getDefaultInstance().print(inputStream, firstPageIndex, lastPageIndex, withPrintDialog);
    }

    public static boolean printPages(JasperPrint jasperPrint, int firstPageIndex, int lastPageIndex, boolean withPrintDialog) throws JRException {
        return JasperPrintManager.getDefaultInstance().print(jasperPrint, firstPageIndex, lastPageIndex, withPrintDialog);
    }

    public static Image printPageToImage(String sourceFileName, int pageIndex, float zoom) throws JRException {
        return JasperPrintManager.getDefaultInstance().printToImage(sourceFileName, pageIndex, zoom);
    }

    public static Image printPageToImage(InputStream inputStream, int pageIndex, float zoom) throws JRException {
        return JasperPrintManager.getDefaultInstance().printToImage(inputStream, pageIndex, zoom);
    }

    public static Image printPageToImage(JasperPrint jasperPrint, int pageIndex, float zoom) throws JRException {
        return JasperPrintManager.getDefaultInstance().printToImage(jasperPrint, pageIndex, zoom);
    }
}

