/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine;

import java.util.Locale;
import java.util.MissingResourceException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.util.MessageProvider;
import net.sf.jasperreports.engine.util.MessageUtil;

public class JRRuntimeException
extends RuntimeException {
    private static final long serialVersionUID = 10200L;
    public static final String ERROR_MESSAGES_BUNDLE = "jasperreports_messages";
    private Object[] args;
    private String messageKey;
    private String localizedMessage;
    private boolean hasLocalizedMessage;

    public JRRuntimeException(String message) {
        super(message);
    }

    public JRRuntimeException(Throwable t) {
        super(t);
    }

    public JRRuntimeException(String message, Throwable t) {
        super(message, t);
    }

    public JRRuntimeException(String messageKey, Object[] args, JasperReportsContext jasperReportsContext, Locale locale) {
        super(messageKey);
        this.messageKey = messageKey;
        this.args = args;
        this.localizedMessage = this.resolveMessage(messageKey, args, jasperReportsContext, locale);
    }

    public String getMessageKey() {
        return this.messageKey;
    }

    public Object[] getArgs() {
        return this.args;
    }

    public boolean hasLocalizedMessage() {
        return this.hasLocalizedMessage;
    }

    @Override
    public String getMessage() {
        if (this.hasLocalizedMessage) {
            return this.localizedMessage;
        }
        return super.getMessage();
    }

    protected String resolveMessage(String messageKey, Object[] args, JasperReportsContext jasperReportsContext, Locale locale) {
        if (messageKey != null) {
            try {
                this.hasLocalizedMessage = true;
                String bundleName = this.getMessageBundleName();
                MessageProvider messageProvider = MessageUtil.getInstance(jasperReportsContext).getMessageProvider(bundleName);
                return messageProvider.getMessage(messageKey, args, locale);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        this.hasLocalizedMessage = false;
        return messageKey;
    }

    protected String getMessageBundleName() {
        return ERROR_MESSAGES_BUNDLE;
    }
}

