/*
 * Decompiled with CFR 0.152.
 */
package rex.graphics.dimensiontree.elements;

import javax.swing.ImageIcon;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import rex.graphics.dimensiontree.elements.DimensionTreeElement;
import rex.metadata.ServerMetadata;
import rex.utils.DOM;
import rex.utils.I18n;
import rex.utils.S;
import rex.xmla.XMLADiscoverProperties;
import rex.xmla.XMLADiscoverRestrictions;

public class HierarchyElement
implements DimensionTreeElement {
    private String catalogName;
    private String cubeName;
    private String dimensionUniqueName;
    private String hierarchyName;
    private String hierarchyUniqueName;
    private String hierarchyGuid;
    private String hierarchyCaption;
    private short dimensionType;
    private int hierarchyCardinality;
    private String defaultMember;
    private String allMember;
    private String description;
    private short structure;
    private boolean isVirtual;
    private boolean isReadwrite;
    private int dimensionUniqueSettings;
    private String dimensionMasterUniqueName;
    private boolean dimensionIsVisible;
    private int hierarchyOrdinal;
    private boolean dimensionIsShared;
    private boolean nodeEnabled;
    private XMLADiscoverRestrictions restrictions;
    private XMLADiscoverProperties properties;
    private ServerMetadata parent;
    static int HIERARCHY_CARDINALITY_NOT_INITIALIZED = -1;
    static ImageIcon icon = S.getAppIcon("hierarchy.gif");

    public HierarchyElement(ServerMetadata svm, Node rowNode, XMLADiscoverRestrictions _restrictions, XMLADiscoverProperties _properties) {
        this.parent = svm;
        this.nodeEnabled = true;
        this.restrictions = _restrictions;
        this.properties = _properties;
        this.hierarchyCardinality = HIERARCHY_CARDINALITY_NOT_INITIALIZED;
        NodeList nl = rowNode.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            if (nl.item(i).getNodeType() != 1) continue;
            if (nl.item(i).getNodeName().equals("CATALOG_NAME")) {
                this.catalogName = DOM.getTextFromDOMElement(nl.item(i));
                continue;
            }
            if (nl.item(i).getNodeName().equals("CUBE_NAME")) {
                this.cubeName = DOM.getTextFromDOMElement(nl.item(i));
                continue;
            }
            if (nl.item(i).getNodeName().equals("DIMENSION_UNIQUE_NAME")) {
                this.dimensionUniqueName = DOM.getTextFromDOMElement(nl.item(i));
                continue;
            }
            if (nl.item(i).getNodeName().equals("HIERARCHY_NAME")) {
                this.hierarchyName = DOM.getTextFromDOMElement(nl.item(i));
                continue;
            }
            if (nl.item(i).getNodeName().equals("HIERARCHY_UNIQUE_NAME")) {
                this.hierarchyUniqueName = DOM.getTextFromDOMElement(nl.item(i));
                continue;
            }
            if (nl.item(i).getNodeName().equals("HIERARCHY_GUID")) {
                this.hierarchyGuid = DOM.getTextFromDOMElement(nl.item(i));
                continue;
            }
            if (nl.item(i).getNodeName().equals("HIERARCHY_CAPTION")) {
                this.hierarchyCaption = DOM.getTextFromDOMElement(nl.item(i));
                continue;
            }
            if (nl.item(i).getNodeName().equals("DIMENSION_TYPE")) {
                this.dimensionType = Short.parseShort(DOM.getTextFromDOMElement(nl.item(i)));
                continue;
            }
            if (nl.item(i).getNodeName().equals("HIERARCHY_CARDINALITY")) {
                this.hierarchyCardinality = Integer.parseInt(DOM.getTextFromDOMElement(nl.item(i)));
                continue;
            }
            if (nl.item(i).getNodeName().equals("DEFAULT_MEMBER")) {
                this.defaultMember = DOM.getTextFromDOMElement(nl.item(i));
                continue;
            }
            if (nl.item(i).getNodeName().equals("ALL_MEMBER")) {
                this.allMember = DOM.getTextFromDOMElement(nl.item(i));
                continue;
            }
            if (nl.item(i).getNodeName().equals("DESCRIPTION")) {
                this.description = DOM.getTextFromDOMElement(nl.item(i));
                continue;
            }
            if (nl.item(i).getNodeName().equals("STRUCTURE")) {
                this.structure = Short.parseShort(DOM.getTextFromDOMElement(nl.item(i)));
                continue;
            }
            if (nl.item(i).getNodeName().equals("IS_VIRTUAL")) {
                this.isVirtual = Boolean.valueOf(DOM.getTextFromDOMElement(nl.item(i)));
                continue;
            }
            if (nl.item(i).getNodeName().equals("IS_READWRITE")) {
                this.isReadwrite = Boolean.valueOf(DOM.getTextFromDOMElement(nl.item(i)));
                continue;
            }
            if (nl.item(i).getNodeName().equals("DIMENSION_UNIQUE_SETTINGS")) {
                this.dimensionUniqueSettings = Integer.parseInt(DOM.getTextFromDOMElement(nl.item(i)));
                continue;
            }
            if (nl.item(i).getNodeName().equals("DIMENSION_MASTER_UNIQUE_NAME")) {
                this.dimensionMasterUniqueName = DOM.getTextFromDOMElement(nl.item(i));
                continue;
            }
            if (nl.item(i).getNodeName().equals("DIMENSION_IS_VISIBLE")) {
                this.dimensionIsVisible = Boolean.valueOf(DOM.getTextFromDOMElement(nl.item(i)));
                continue;
            }
            if (nl.item(i).getNodeName().equals("HIERARCHY_ORDINAL")) {
                this.hierarchyOrdinal = Integer.parseInt(DOM.getTextFromDOMElement(nl.item(i)));
                continue;
            }
            if (!nl.item(i).getNodeName().equals("DIMENSION_IS_SHARED")) continue;
            this.dimensionIsShared = Boolean.valueOf(DOM.getTextFromDOMElement(nl.item(i)));
        }
    }

    @Override
    public DimensionTreeElement[] getChildren(boolean noMatterWhat) {
        this.restrictions.setDimensionUniqueName(this.dimensionUniqueName);
        this.restrictions.setHierarchyUniqueName(this.hierarchyUniqueName);
        return this.parent.getLevelList(this.restrictions, this.properties);
    }

    @Override
    public String toString() {
        if (this.hierarchyName == null) {
            return I18n.getString("toolTip.notInitialized");
        }
        return this.hierarchyName;
    }

    @Override
    public ImageIcon getIcon() {
        return icon;
    }

    @Override
    public String getToolTip() {
        if (this.hierarchyName == null) {
            return I18n.getString("toolTip.notInitialized");
        }
        return "" + this.hierarchyName + I18n.getString("toolTip.caption") + this.hierarchyCaption + I18n.getString("toolTip.dimensionUniqueName") + this.dimensionUniqueName;
    }

    @Override
    public String[] getPopUpActionList() {
        return null;
    }

    public String getHierarchyUniqueName() {
        return this.hierarchyUniqueName;
    }

    @Override
    public String getDimensionUniqueName() {
        return this.dimensionUniqueName;
    }

    @Override
    public String getUniqueName() {
        return this.hierarchyUniqueName;
    }

    @Override
    public String getCaption() {
        return this.hierarchyCaption;
    }

    public String getQueryMembersExpression() {
        return this.hierarchyUniqueName + ".Members";
    }

    @Override
    public boolean isEnabled() {
        return this.nodeEnabled;
    }

    @Override
    public void setEnabled(boolean newValue) {
        this.nodeEnabled = newValue;
    }

    @Override
    public int getChildrenCount() {
        if (this.hierarchyCardinality == HIERARCHY_CARDINALITY_NOT_INITIALIZED) {
            DimensionTreeElement[] list = this.getChildren(true);
            this.hierarchyCardinality = list == null ? 0 : list.length;
        }
        return this.hierarchyCardinality;
    }

    @Override
    public ServerMetadata getServerMetadata() {
        return this.parent;
    }

    @Override
    public XMLADiscoverRestrictions getRestrictions() {
        return this.restrictions;
    }

    @Override
    public XMLADiscoverProperties getProperties() {
        return this.properties;
    }
}

