/*
 * Decompiled with CFR 0.152.
 */
package rex.graphics.datasourcetree;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import rex.graphics.TreeElement;
import rex.graphics.datasourcetree.elements.DataSourceHostElement;
import rex.graphics.datasourcetree.elements.DataSourceRootElement;
import rex.graphics.datasourcetree.elements.DataSourceTreeElement;
import rex.metadata.ServerMetadata;
import rex.utils.I18n;
import rex.utils.S;

public class DataSourceTreeModel
implements TreeModel {
    private Vector treeModelListeners;
    private TreeElement root = new TreeElement(new DataSourceRootElement(), null);
    private Map urls;

    public DataSourceTreeModel() {
        this.treeModelListeners = new Vector();
        this.urls = new Hashtable();
    }

    public String getUname() {
        return "Igor rules!";
    }

    private void maybeAddDataSource(String URL2) {
        try {
            String s;
            RandomAccessFile rf = new RandomAccessFile("startup.datasources.txt", "rw");
            while ((s = rf.readLine()) != null) {
                if (!s.equalsIgnoreCase(URL2)) continue;
                S.out("URL already present in startup.datasources.txt");
                rf.close();
                return;
            }
            if (0 == JOptionPane.showConfirmDialog(null, I18n.getString("msgText.confirmUrl"), I18n.getString("msgTitle.confirmUrl"), 0)) {
                rf.seek(rf.length());
                rf.writeBytes(URL2.trim() + "\n");
            }
            rf.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void addDataSource(String URL2) {
        DataSourceRootElement rootData = (DataSourceRootElement)this.root.getUserObject();
        if (!this.urls.containsKey(URL2)) {
            ServerMetadata smd = new ServerMetadata(URL2);
            DataSourceTreeElement[] ds = smd.discoverDataSources();
            if (ds != null) {
                try {
                    this.urls.put(URL2, new URL(URL2));
                }
                catch (MalformedURLException e) {
                    // empty catch block
                }
                TreeElement host = new TreeElement(new DataSourceHostElement(URL2), this.root);
                this.root.addChild(host);
                this.maybeAddDataSource(URL2);
                for (int i = 0; ds != null && i < ds.length; ++i) {
                    TreeElement dataSource = new TreeElement(ds[i], host);
                    host.addChild(dataSource);
                    this.buildTreeRecursively(dataSource);
                }
                this.fireTreeStructureChanged(this.root);
            }
        } else {
            JOptionPane.showMessageDialog(null, URL2 + " " + I18n.getString("msgText.duplicateDSURL"), I18n.getString("msgTitle.addDS"), 2);
        }
    }

    private void buildTreeRecursively(TreeElement parent) {
        DataSourceTreeElement[] ds = ((DataSourceTreeElement)parent.getUserObject()).getChildren();
        for (int i = 0; ds != null && i < ds.length; ++i) {
            TreeElement node = new TreeElement(ds[i], parent);
            parent.addChild(node);
            this.buildTreeRecursively(node);
        }
    }

    protected void fireTreeStructureChanged(TreeElement oldRoot) {
        int len = this.treeModelListeners.size();
        TreeModelEvent e = new TreeModelEvent((Object)this, new Object[]{oldRoot});
        for (int i = 0; i < len; ++i) {
            ((TreeModelListener)this.treeModelListeners.elementAt(i)).treeStructureChanged(e);
        }
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.treeModelListeners.addElement(l);
    }

    @Override
    public Object getChild(Object parent, int index) {
        TreeElement p = (TreeElement)parent;
        return p.getChildAt(index);
    }

    @Override
    public int getChildCount(Object parent) {
        TreeElement p = (TreeElement)parent;
        return p.getChildCount();
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        TreeElement p = (TreeElement)parent;
        return p.getIndexOfChild((TreeElement)child);
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public boolean isLeaf(Object node) {
        TreeElement p = (TreeElement)node;
        return p.getChildCount() == 0;
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.treeModelListeners.removeElement(l);
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        System.out.println("*** valueForPathChanged : " + path + " --> " + newValue);
    }
}

