/*
 * Decompiled with CFR 0.152.
 */
package rex;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.util.Locale;
import java.util.Properties;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.apache.log4j.PropertyConfigurator;
import rex.LogPropertyGenerator;
import rex.graphics.RexTabbedPane;
import rex.graphics.datasourcetree.DataSourceTree;
import rex.graphics.mdxeditor.jsp.ReadEnv;
import rex.graphics.mdxeditor.mdxbuilder.dnd.DragElement;
import rex.utils.I18n;
import rex.utils.LanguageChangedEvent;
import rex.utils.LanguageChangedListener;
import rex.utils.RexDefaultProperties;
import rex.utils.S;

public class WarehouseExplorer
extends JPanel
implements LanguageChangedListener {
    String strHelpLabel = "";
    String version = "0.7";
    String strLanguage = "";
    String strCountry = "";
    int idx = 0;
    public JLabel helpLabel = new JLabel(this.strHelpLabel);
    JTabbedPane tabbedPane = new RexTabbedPane();
    DataSourceTree dsTree = new DataSourceTree(this.tabbedPane);
    public static Locale lastLocale = null;

    public WarehouseExplorer() {
        I18n.addOnLanguageChangedListener(this);
        this.applyI18n();
        JPanel helpPanel = new JPanel();
        helpPanel.setLayout(new BoxLayout(helpPanel, 1));
        helpPanel.add(Box.createRigidArea(new Dimension(50, 50)));
        helpPanel.add(this.helpLabel);
        helpPanel.setOpaque(false);
        JPanel treeAndHelp = new JPanel(){
            {
                this.setOpaque(false);
            }

            @Override
            public void paintComponent(Graphics g) {
                S.paintBackground(g, this);
                super.paintComponent(g);
            }
        };
        treeAndHelp.setLayout(new BoxLayout(treeAndHelp, 0));
        treeAndHelp.add(this.dsTree);
        treeAndHelp.add(helpPanel);
        this.tabbedPane.addTab(I18n.getString("tabTitle.dataSources"), null, treeAndHelp, I18n.getString("toolTip.dataSource"));
        this.tabbedPane.setSelectedIndex(0);
        ((RexTabbedPane)this.tabbedPane).setIconAnimationOff();
        this.setLayout(new GridLayout(1, 1));
        this.add(this.tabbedPane);
    }

    @Override
    public void languageChanged(LanguageChangedEvent evt) {
        this.applyI18n();
    }

    @Override
    public void removeLanguageListener() {
        I18n.removeOnLanguageChangedListener(this);
        this.dsTree.removeLanguageListener();
    }

    public void applyI18n() {
        if (lastLocale != null && lastLocale == I18n.getCurrentLocale()) {
            return;
        }
        lastLocale = I18n.getCurrentLocale();
        this.strHelpLabel = I18n.getString("label.help1");
        this.strHelpLabel = this.strHelpLabel + I18n.getString("label.help2");
        this.strHelpLabel = this.strHelpLabel + I18n.getString("label.help3");
        this.strHelpLabel = this.strHelpLabel + I18n.getString("label.help4");
        this.strHelpLabel = this.strHelpLabel + I18n.getString("label.help5");
        this.strHelpLabel = this.strHelpLabel + I18n.getString("label.help6");
        this.strHelpLabel = this.strHelpLabel + I18n.getString("label.help7");
        this.strHelpLabel = this.strHelpLabel + I18n.getString("label.help8");
        this.helpLabel.setText(this.strHelpLabel);
    }

    public void localize() {
        String file = System.getProperty("user.home") + File.separator + "rex.properties";
        Properties rexProp = new Properties();
        try {
            rexProp.load(new FileInputStream(new File(file)));
        }
        catch (Exception e) {
            S.out("Error reading rex.properties file");
        }
        this.strLanguage = rexProp.getProperty("Language");
        if (this.strLanguage != "") {
            Locale oLang = new Locale(this.strLanguage);
            I18n.setCurrentLocale(oLang);
        } else {
            I18n.setCurrentLocale(Locale.getDefault());
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Warehouse Explorer");
        frame.setGlassPane(new DragElement());
        try {
            new LogPropertyGenerator();
            PropertyConfigurator.configure((String)(ReadEnv.getEnvVars().getProperty("USERPROFILE") + "\\rex.properties"));
            RexDefaultProperties.createDefaultProperties();
        }
        catch (Exception exception) {
            S.reportError(exception);
        }
        final WarehouseExplorer explorer = new WarehouseExplorer();
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                explorer.removeLanguageListener();
                System.exit(0);
            }
        });
        frame.getContentPane().add((Component)explorer, "Center");
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Rectangle bounds = env.getMaximumWindowBounds();
        frame.setSize((int)bounds.getWidth(), (int)bounds.getHeight());
        frame.setVisible(true);
    }
}

