/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;

public class NumericHistogram {
    private int nbins = 0;
    private int nusedbins = 0;
    private Coord[] bins = null;
    private Random prng = new Random(31183L);

    public void reset() {
        this.bins = null;
        this.nusedbins = 0;
        this.nbins = 0;
    }

    public int getUsedBins() {
        return this.nusedbins;
    }

    public boolean isReady() {
        return this.nbins != 0;
    }

    public Coord getBin(int b) {
        return this.bins[b];
    }

    public void allocate(int num_bins) {
        this.nbins = num_bins;
        this.bins = new Coord[this.nbins + 1];
        for (int i = 0; i < this.nbins + 1; ++i) {
            this.bins[i] = new Coord();
        }
        this.nusedbins = 0;
    }

    public void merge(List<DoubleWritable> other) {
        if (other == null) {
            return;
        }
        if (this.nbins == 0 || this.nusedbins == 0) {
            this.nbins = (int)other.get(0).get();
            this.nusedbins = (other.size() - 1) / 2;
            this.bins = new Coord[this.nbins + 1];
            for (int i = 1; i < other.size(); i += 2) {
                this.bins[(i - 1) / 2] = new Coord();
                this.bins[(i - 1) / 2].x = other.get(i).get();
                this.bins[(i - 1) / 2].y = other.get(i + 1).get();
            }
        } else {
            int i;
            Object[] tmp_bins = new Coord[this.nusedbins + (other.size() - 1) / 2];
            for (int j = 0; j < tmp_bins.length; ++j) {
                tmp_bins[j] = new Coord();
            }
            for (i = 0; i < this.nusedbins; ++i) {
                tmp_bins[i].x = this.bins[i].x;
                ((Coord)tmp_bins[i]).y = this.bins[i].y;
            }
            int j = 1;
            while (j < other.size()) {
                ((Coord)tmp_bins[i]).x = other.get(j).get();
                ((Coord)tmp_bins[i]).y = other.get(j + 1).get();
                j += 2;
                ++i;
            }
            Arrays.sort(tmp_bins);
            this.bins = tmp_bins;
            this.nusedbins += (other.size() - 1) / 2;
            this.trim();
        }
    }

    public void add(double v) {
        int bin = 0;
        int l = 0;
        int r = this.nusedbins;
        while (l < r) {
            bin = (l + r) / 2;
            if (this.bins[bin].x > v) {
                r = bin;
                continue;
            }
            if (!(this.bins[bin].x < v)) break;
            l = ++bin;
        }
        if (bin < this.nusedbins && this.bins[bin].x == v) {
            this.bins[bin].y += 1.0;
        } else {
            for (int i = this.nusedbins; i > bin; --i) {
                this.bins[i].x = this.bins[i - 1].x;
                this.bins[i].y = this.bins[i - 1].y;
            }
            this.bins[bin].x = v;
            this.bins[bin].y = 1.0;
            if (++this.nusedbins > this.nbins) {
                this.trim();
            }
        }
    }

    private void trim() {
        while (this.nusedbins > this.nbins) {
            double smallestdiff = this.bins[1].x - this.bins[0].x;
            int smallestdiffloc = 0;
            int smallestdiffcount = 1;
            for (int i = 1; i < this.nusedbins - 1; ++i) {
                double diff = this.bins[i + 1].x - this.bins[i].x;
                if (diff < smallestdiff) {
                    smallestdiff = diff;
                    smallestdiffloc = i;
                    smallestdiffcount = 1;
                    continue;
                }
                if (diff != smallestdiff) continue;
                ++smallestdiffcount;
                if (!(this.prng.nextDouble() <= 1.0 / (double)smallestdiffcount)) continue;
                smallestdiffloc = i;
            }
            double d = this.bins[smallestdiffloc].y + this.bins[smallestdiffloc + 1].y;
            this.bins[smallestdiffloc].x *= this.bins[smallestdiffloc].y / d;
            this.bins[smallestdiffloc].x += this.bins[smallestdiffloc + 1].x / d * this.bins[smallestdiffloc + 1].y;
            this.bins[smallestdiffloc].y = d;
            for (int i = smallestdiffloc + 1; i < this.nusedbins - 1; ++i) {
                this.bins[i].x = this.bins[i + 1].x;
                this.bins[i].y = this.bins[i + 1].y;
            }
            --this.nusedbins;
        }
    }

    public double quantile(double q) {
        int b;
        assert (this.bins != null && this.nusedbins > 0 && this.nbins > 0);
        double sum = 0.0;
        double csum = 0.0;
        for (b = 0; b < this.nusedbins; ++b) {
            sum += this.bins[b].y;
        }
        for (b = 0; b < this.nusedbins; ++b) {
            if (!((csum += this.bins[b].y) / sum >= q)) continue;
            if (b == 0) {
                return this.bins[b].x;
            }
            double r = this.bins[b - 1].x + (q * sum - (csum -= this.bins[b].y)) * (this.bins[b].x - this.bins[b - 1].x) / this.bins[b].y;
            return r;
        }
        return -1.0;
    }

    public ArrayList<DoubleWritable> serialize() {
        ArrayList<DoubleWritable> result = new ArrayList<DoubleWritable>();
        result.add(new DoubleWritable(this.nbins));
        if (this.bins != null) {
            for (int i = 0; i < this.nusedbins; ++i) {
                result.add(new DoubleWritable(this.bins[i].x));
                result.add(new DoubleWritable(this.bins[i].y));
            }
        }
        return result;
    }

    static class Coord
    implements Comparable {
        double x;
        double y;

        Coord() {
        }

        public int compareTo(Object other) {
            Coord o = (Coord)other;
            if (this.x < o.x) {
                return -1;
            }
            if (this.x > o.x) {
                return 1;
            }
            return 0;
        }
    }
}

