/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.jbc2;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.Region;
import org.hibernate.cache.jbc2.util.CacheHelper;
import org.hibernate.cache.jbc2.util.NonLockingDataVersion;
import org.jboss.cache.Cache;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.Option;
import org.jboss.cache.notifications.annotation.CacheListener;
import org.jboss.cache.optimistic.DataVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@CacheListener
public abstract class BasicRegionAdapter
implements Region {
    public static final String ITEM = "item";
    protected final Cache jbcCache;
    protected final String regionName;
    protected final Fqn regionFqn;
    protected Node regionRoot;
    protected final boolean optimistic;
    protected final TransactionManager transactionManager;
    protected final Logger log;
    protected final Object regionRootMutex = new Object();

    public BasicRegionAdapter(Cache jbcCache, String regionName, String regionPrefix) {
        this.jbcCache = jbcCache;
        this.transactionManager = jbcCache.getConfiguration().getRuntimeConfig().getTransactionManager();
        this.regionName = regionName;
        this.regionFqn = this.createRegionFqn(regionName, regionPrefix);
        this.optimistic = jbcCache.getConfiguration().getNodeLockingScheme() == Configuration.NodeLockingScheme.OPTIMISTIC;
        this.log = LoggerFactory.getLogger(this.getClass());
        this.activateLocalClusterNode();
        this.log.debug("Created Region for " + regionName + " -- regionPrefix is " + regionPrefix);
    }

    protected abstract Fqn<String> createRegionFqn(String var1, String var2);

    protected void activateLocalClusterNode() {
        Transaction tx = this.suspend();
        try {
            Configuration cfg = this.jbcCache.getConfiguration();
            if (cfg.isUseRegionBasedMarshalling()) {
                org.jboss.cache.Region jbcRegion = this.jbcCache.getRegion(this.regionFqn, true);
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                if (classLoader == null) {
                    classLoader = this.getClass().getClassLoader();
                }
                jbcRegion.registerContextClassLoader(classLoader);
                if (!jbcRegion.isActive()) {
                    jbcRegion.activate();
                }
            }
            this.regionRoot = this.jbcCache.getRoot().getChild(this.regionFqn);
            if (this.regionRoot == null || !this.regionRoot.isValid()) {
                DataVersion version = this.optimistic ? NonLockingDataVersion.INSTANCE : null;
                this.regionRoot = CacheHelper.addNode(this.jbcCache, this.regionFqn, true, true, version);
            } else if (this.optimistic && this.regionRoot instanceof NodeSPI && !(((NodeSPI)this.regionRoot).getVersion() instanceof NonLockingDataVersion)) {
                ((NodeSPI)this.regionRoot).setVersion(NonLockingDataVersion.INSTANCE);
            }
            if (!this.regionRoot.isResident()) {
                this.regionRoot.setResident(true);
            }
        }
        catch (Exception e) {
            throw new CacheException(e.getMessage(), e);
        }
        finally {
            if (tx != null) {
                this.resume(tx);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void establishRegionRootNode() {
        Object object = this.regionRootMutex;
        synchronized (object) {
            if (this.regionRoot != null && this.regionRoot.isValid()) {
                return;
            }
            if (!this.optimistic) {
                this.regionRoot = this.jbcCache.getRoot().getChild(this.regionFqn);
                return;
            }
            Transaction tx = this.suspend();
            Node newRoot = null;
            try {
                newRoot = this.jbcCache.getRoot().getChild(this.regionFqn);
                if (newRoot == null || !newRoot.isValid()) {
                    DataVersion version = this.optimistic ? NonLockingDataVersion.INSTANCE : null;
                    newRoot = CacheHelper.addNode(this.jbcCache, this.regionFqn, true, true, version);
                } else if (newRoot instanceof NodeSPI && !(((NodeSPI)newRoot).getVersion() instanceof NonLockingDataVersion)) {
                    ((NodeSPI)newRoot).setVersion(NonLockingDataVersion.INSTANCE);
                }
                newRoot.setResident(true);
            }
            finally {
                this.resume(tx);
                this.regionRoot = newRoot;
            }
        }
    }

    @Override
    public String getName() {
        return this.regionName;
    }

    public Cache getCacheInstance() {
        return this.jbcCache;
    }

    public Fqn getRegionFqn() {
        return this.regionFqn;
    }

    public void ensureRegionRootExists() {
        if (this.regionRoot == null || !this.regionRoot.isValid()) {
            this.establishRegionRootNode();
        }
        if (this.regionRoot != null && this.regionRoot.isValid() && !this.regionRoot.isResident()) {
            this.regionRoot.setResident(true);
        }
    }

    @Override
    public void destroy() throws CacheException {
        try {
            Option option = new Option();
            option.setCacheModeLocal(true);
            option.setFailSilently(true);
            if (this.optimistic) {
                option.setDataVersion(NonLockingDataVersion.INSTANCE);
            }
            this.jbcCache.getInvocationContext().setOptionOverrides(option);
            this.jbcCache.removeNode(this.regionFqn);
            this.deactivateLocalNode();
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
    }

    protected void deactivateLocalNode() {
        org.jboss.cache.Region jbcRegion = this.jbcCache.getRegion(this.regionFqn, false);
        if (jbcRegion != null && jbcRegion.isActive()) {
            jbcRegion.deactivate();
            jbcRegion.unregisterContextClassLoader();
        }
    }

    @Override
    public long getSizeInMemory() {
        return -1L;
    }

    @Override
    public long getElementCountInMemory() {
        try {
            Set childrenNames = CacheHelper.getChildrenNames(this.jbcCache, this.regionFqn);
            return childrenNames.size();
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
    }

    @Override
    public long getElementCountOnDisk() {
        return -1L;
    }

    @Override
    public Map toMap() {
        try {
            HashMap result = new HashMap();
            Set childrenNames = CacheHelper.getChildrenNames(this.jbcCache, this.regionFqn);
            for (Object childName : childrenNames) {
                result.put(childName, CacheHelper.get(this.jbcCache, this.regionFqn, childName));
            }
            return result;
        }
        catch (CacheException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
    }

    @Override
    public long nextTimestamp() {
        return System.currentTimeMillis() / 100L;
    }

    @Override
    public int getTimeout() {
        return 600;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object suspendAndGet(Object key, Option opt, boolean suppressTimeout) throws CacheException {
        Transaction tx = this.suspend();
        try {
            CacheHelper.setInvocationOption(this.getCacheInstance(), opt);
            if (suppressTimeout) {
                Object object = CacheHelper.getAllowingTimeout(this.getCacheInstance(), this.getRegionFqn(), key);
                return object;
            }
            Object object = CacheHelper.get(this.getCacheInstance(), this.getRegionFqn(), key);
            return object;
        }
        finally {
            this.resume(tx);
        }
    }

    protected Transaction suspend() {
        Transaction tx = null;
        try {
            if (this.transactionManager != null) {
                tx = this.transactionManager.suspend();
            }
        }
        catch (SystemException se) {
            throw new CacheException("Could not suspend transaction", se);
        }
        return tx;
    }

    protected void resume(Transaction tx) {
        try {
            if (tx != null) {
                this.transactionManager.resume(tx);
            }
        }
        catch (Exception e) {
            throw new CacheException("Could not resume transaction", e);
        }
    }

    protected Option getNonLockingDataVersionOption(boolean allowNullReturn) {
        return this.optimistic ? NonLockingDataVersion.getInvocationOption() : (allowNullReturn ? null : new Option());
    }

    public static Fqn<String> getTypeFirstRegionFqn(String regionName, String regionPrefix, String regionType) {
        Fqn base = Fqn.fromString((String)regionType);
        Fqn added = Fqn.fromString((String)BasicRegionAdapter.escapeRegionName(regionName, regionPrefix));
        return new Fqn(base, added);
    }

    public static Fqn<String> getTypeLastRegionFqn(String regionName, String regionPrefix, String regionType) {
        Fqn base = Fqn.fromString((String)BasicRegionAdapter.escapeRegionName(regionName, regionPrefix));
        return new Fqn(base, (Object[])new String[]{regionType});
    }

    public static String escapeRegionName(String regionName, String regionPrefix) {
        String escaped = null;
        int idx = -1;
        if (regionPrefix != null) {
            idx = regionName.indexOf(regionPrefix);
        }
        if (idx > -1) {
            int regionEnd = idx + regionPrefix.length();
            String prefix = regionName.substring(0, regionEnd);
            String suffix = regionName.substring(regionEnd);
            suffix = suffix.replace('.', '/');
            escaped = prefix + suffix;
        } else {
            escaped = regionName.replace('.', '/');
            if (regionPrefix != null && regionPrefix.length() > 0) {
                escaped = regionPrefix + "/" + escaped;
            }
        }
        return escaped;
    }
}

