/*
 * MarkerDialog.java
 *
 * Created on Nov 2, 2012, 11:00:14 AM
 */

package com.jaspersoft.ireport.components.map;

import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.locale.I18n;
import javax.swing.JOptionPane;
import net.sf.jasperreports.components.map.Marker;
import net.sf.jasperreports.components.map.MarkerProperty;
import net.sf.jasperreports.components.map.StandardMarker;
import net.sf.jasperreports.components.map.StandardMarkerProperty;

/**
 *
 * @author gtoffoli
 */


public class MarkerDialog extends javax.swing.JDialog {

    
    private StandardMarker marker = null;
    private int dialogResult = JOptionPane.CANCEL_OPTION;
    
    /** Creates new form MarkerDialog */
    public MarkerDialog(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        initComponents();
        
        markerPropertyPanelLatitude.setMarkerProperty(new StandardMarkerProperty(Marker.PROPERTY_latitude, null, Misc.createExpression(null, "0")));
        markerPropertyPanelLongitude.setMarkerProperty(new StandardMarkerProperty(Marker.PROPERTY_longitude, null, Misc.createExpression(null, "0")));
        
        
        setLocationRelativeTo(null);
        
        javax.swing.KeyStroke escape =  javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_ESCAPE, 0, false);
        javax.swing.Action escapeAction = new javax.swing.AbstractAction() {
            public void actionPerformed(java.awt.event.ActionEvent e) {
                jButtonCancelActionPerformed(e);
            }
        };
       
        getRootPane().getInputMap(javax.swing.JComponent.WHEN_IN_FOCUSED_WINDOW).put(escape, I18n.getString("Global.Pane.Escape"));
        getRootPane().getActionMap().put(I18n.getString("Global.Pane.Escape"), escapeAction);



        //to make the default button ...
        this.getRootPane().setDefaultButton(this.jButtonOk);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        markerPropertyPanelLatitude = new com.jaspersoft.ireport.components.map.MarkerPropertyPanel();
        markerPropertyPanelLongitude = new com.jaspersoft.ireport.components.map.MarkerPropertyPanel();
        jPanel2 = new javax.swing.JPanel();
        jButtonOk = new javax.swing.JButton();
        jButtonCancel = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle(org.openide.util.NbBundle.getMessage(MarkerDialog.class, "MarkerDialog.title")); // NOI18N
        getContentPane().setLayout(new java.awt.GridBagLayout());
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipady = 61;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        getContentPane().add(markerPropertyPanelLatitude, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipady = 61;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        getContentPane().add(markerPropertyPanelLongitude, gridBagConstraints);

        jButtonOk.setText(org.openide.util.NbBundle.getMessage(MarkerDialog.class, "MarkerDialog.jButtonOk.text")); // NOI18N
        jButtonOk.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonOkActionPerformed(evt);
            }
        });

        jButtonCancel.setText(org.openide.util.NbBundle.getMessage(MarkerDialog.class, "MarkerDialog.jButtonCancel.text")); // NOI18N
        jButtonCancel.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonCancelActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout jPanel2Layout = new org.jdesktop.layout.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, jPanel2Layout.createSequentialGroup()
                .addContainerGap(267, Short.MAX_VALUE)
                .add(jButtonOk)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jButtonCancel))
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                .add(jButtonCancel)
                .add(jButtonOk))
        );

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTHEAST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        getContentPane().add(jPanel2, gridBagConstraints);

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jButtonOkActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonOkActionPerformed

        this.setDialogResult(JOptionPane.OK_OPTION);
        setVisible(false);
        dispose();     
    
        
        
    }//GEN-LAST:event_jButtonOkActionPerformed

    private void jButtonCancelActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonCancelActionPerformed

         this.setDialogResult(JOptionPane.CANCEL_OPTION);
         setVisible(false);
         dispose();
         
    }//GEN-LAST:event_jButtonCancelActionPerformed

    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonCancel;
    private javax.swing.JButton jButtonOk;
    private javax.swing.JPanel jPanel2;
    private com.jaspersoft.ireport.components.map.MarkerPropertyPanel markerPropertyPanelLatitude;
    private com.jaspersoft.ireport.components.map.MarkerPropertyPanel markerPropertyPanelLongitude;
    // End of variables declaration//GEN-END:variables

    /**
     * @return the dialogResult
     */
    public int getDialogResult() {
        return dialogResult;
    }

    /**
     * @param dialogResult the dialogResult to set
     */
    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    /**
     * @return the marker
     */
    public StandardMarker getMarker() {
        
        

        //if (marker == null)
        {
            marker = new StandardMarker();
        }
        
       
        marker.addMarkerProperty(markerPropertyPanelLatitude.getMarkerProperty() );
        marker.addMarkerProperty(markerPropertyPanelLongitude.getMarkerProperty() );
        
        return marker;
    }

    /**
     * @param marker the marker to set
     */
    public void setMarker(StandardMarker marker) {
        this.marker = (StandardMarker) marker.clone();
        
        for (MarkerProperty p : this.marker.getProperties())
        {
            StandardMarkerProperty sp = (StandardMarkerProperty)p;
            
            if (p.getName().equals( Marker.PROPERTY_latitude))
            {
                markerPropertyPanelLatitude.setMarkerProperty(sp);
            }
            else if (p.getName().equals( Marker.PROPERTY_longitude))
            {
                markerPropertyPanelLongitude.setMarkerProperty(sp);
            }
        }
    }
}
