/*
 * iReport - Visual Designer for JasperReports.
 * Copyright (C) 2002 - 2013 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com
 *
 * Unless you have purchased a commercial license agreement from Jaspersoft,
 * the following license terms apply:
 *
 * This program is part of iReport.
 *
 * iReport is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * iReport is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with iReport. If not, see <http://www.gnu.org/licenses/>.
 */
package com.jaspersoft.ireport.designer.crosstab.wizard;

import com.jaspersoft.ireport.locale.I18n;
import java.awt.BorderLayout;
import javax.swing.JPanel;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabMeasure;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.type.CalculationEnum;

public final class CrosstabVisualPanel4 extends JPanel {

    JRDesignDataset dataset = null;
    
    GroupPanel groupPanel1 = new GroupPanel(GroupPanel.MEASURE);
    
    /** Creates new form CrosstabVisualPanel2 */
    public CrosstabVisualPanel4() {
        initComponents();
        jPanelGroup1.add(groupPanel1, BorderLayout.CENTER);
        
        groupPanel1.setTitle(I18n.getString("CrosstabVisualPanel4.Title.Data"));

    }

    public void setDataset(JRDesignDataset dataset)
    {
        if (this.dataset == dataset) return;
        
        this.dataset = dataset;
        groupPanel1.setDataset(dataset, false);
    }
    
    @Override
    public String getName() {
        return I18n.getString("CrosstabVisualPanel4.Label.Measure");
    }

    public JRDesignCrosstabMeasure getMeasure()
    {
        JRDesignCrosstabMeasure measure = new JRDesignCrosstabMeasure();
        measure.setName( groupPanel1.getGroupMeasureName()+I18n.getString("CrosstabVisualPanel4.Label.Measure") );
        measure.setValueExpression( groupPanel1.getDesignExpression() );
        measure.setCalculation( groupPanel1.getCalculationType() );
        measure.setValueClassName( groupPanel1.getDesignExpression().getValueClassName() );
        if (groupPanel1.getCalculationType() == CalculationEnum.COUNT)
        {
            measure.setValueClassName( "java.lang.Integer");
        }
        else
        {
            measure.setValueClassName( measure.getValueExpression().getValueClassName() );
        }
        
        return measure;
    }
    
    
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabel1 = new javax.swing.JLabel();
        jPanelGroup1 = new javax.swing.JPanel();

        jLabel1.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel1.setIcon(new javax.swing.ImageIcon(getClass().getResource("/com/jaspersoft/ireport/designer/resources/wizard_details.png"))); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(jLabel1, I18n.getString("CrosstabVisualPanel4.Label.DefineMeasure")); // NOI18N
        jLabel1.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jLabel1.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);

        jPanelGroup1.setMinimumSize(new java.awt.Dimension(100, 100));
        jPanelGroup1.setPreferredSize(new java.awt.Dimension(100, 100));
        jPanelGroup1.setLayout(new java.awt.BorderLayout());

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jLabel1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 381, Short.MAX_VALUE)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(jPanelGroup1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 361, Short.MAX_VALUE)
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(jLabel1)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                .add(jPanelGroup1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(129, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLabel1;
    private javax.swing.JPanel jPanelGroup1;
    // End of variables declaration//GEN-END:variables
}

