/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.MondrianProperties;
import mondrian.olap.NativeEvaluator;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapEvaluator;
import mondrian.rolap.RolapNativeSet;
import mondrian.rolap.RolapNativeSql;
import mondrian.rolap.SqlConstraintUtils;
import mondrian.rolap.aggmatcher.AggStar;
import mondrian.rolap.sql.CrossJoinArg;
import mondrian.rolap.sql.SqlQuery;

public class RolapNativeFilter
extends RolapNativeSet {
    public RolapNativeFilter() {
        super.setEnabled(MondrianProperties.instance().EnableNativeFilter.get());
    }

    protected boolean restrictMemberTypes() {
        return true;
    }

    NativeEvaluator createEvaluator(RolapEvaluator evaluator, FunDef fun, Exp[] args) {
        CrossJoinArg[] predicateArgs;
        Exp filterExpr;
        if (!this.isEnabled()) {
            return null;
        }
        if (!FilterConstraint.isValidContext(evaluator, this.restrictMemberTypes())) {
            return null;
        }
        String funName = fun.getName();
        if (!"Filter".equalsIgnoreCase(funName)) {
            return null;
        }
        if (args.length != 2) {
            return null;
        }
        List<CrossJoinArg[]> allArgs = this.crossJoinArgFactory().checkCrossJoinArg(evaluator, args[0]);
        if (allArgs == null || allArgs.isEmpty() || allArgs.get(0) == null) {
            return null;
        }
        CrossJoinArg[] cjArgs = allArgs.get(0);
        if (this.isPreferInterpreter(cjArgs, false)) {
            return null;
        }
        SchemaReader schemaReader = evaluator.getSchemaReader();
        DataSource ds = schemaReader.getDataSource();
        SqlQuery sqlQuery = SqlQuery.newQuery(ds, "NativeFilter");
        RolapNativeSql sql = new RolapNativeSql(sqlQuery, null);
        String filterExprStr = sql.generateFilterCondition(filterExpr = args[1]);
        if (filterExprStr == null) {
            return null;
        }
        if (SqlConstraintUtils.containsCalculatedMember(evaluator.getNonAllMembers())) {
            return null;
        }
        LOGGER.debug((Object)"using native filter");
        evaluator = this.overrideContext(evaluator, cjArgs, sql.getStoredMeasure());
        CrossJoinArg[] combinedArgs = cjArgs;
        if (allArgs.size() == 2 && (predicateArgs = allArgs.get(1)) != null) {
            combinedArgs = Util.appendArrays(cjArgs, new CrossJoinArg[][]{predicateArgs});
        }
        FilterConstraint constraint = new FilterConstraint(combinedArgs, evaluator, filterExpr);
        return new RolapNativeSet.SetEvaluator(this, cjArgs, schemaReader, constraint);
    }

    static class FilterConstraint
    extends RolapNativeSet.SetConstraint {
        Exp filterExpr;

        public FilterConstraint(CrossJoinArg[] args, RolapEvaluator evaluator, Exp filterExpr) {
            super(args, evaluator, true);
            this.filterExpr = filterExpr;
        }

        protected boolean isJoinRequired() {
            return true;
        }

        public void addConstraint(SqlQuery sqlQuery, RolapCube baseCube, AggStar aggStar) {
            RolapNativeSql sql = new RolapNativeSql(sqlQuery, aggStar);
            String filterSql = sql.generateFilterCondition(this.filterExpr);
            sqlQuery.addHaving(filterSql);
            super.addConstraint(sqlQuery, baseCube, aggStar);
        }

        public Object getCacheKey() {
            ArrayList<Object> key = new ArrayList<Object>();
            key.add(super.getCacheKey());
            if (this.filterExpr != null) {
                key.add(this.filterExpr.toString());
            }
            return key;
        }
    }
}

