/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public final class JRStringUtil {
    protected static final String JAVA_IDENTIFIER_PREFIX = "j";

    public static String replaceCRwithLF(String text) {
        if (text != null) {
            int length = text.length();
            char[] chars = text.toCharArray();
            int r = 0;
            boolean dirty = false;
            for (int i = 0; i < length; ++i) {
                char ch = chars[i];
                if (ch == '\r') {
                    dirty = true;
                    if (i + 1 < length && chars[i + 1] == '\n') {
                        ++r;
                        continue;
                    }
                    chars[i - r] = 10;
                    continue;
                }
                chars[i - r] = ch;
            }
            return dirty ? new String(chars, 0, length - r) : text;
        }
        return null;
    }

    public static String xmlEncode(String text) {
        return JRStringUtil.xmlEncode(text, null);
    }

    public static String xmlEncode(String text, String invalidCharReplacement) {
        if (text == null || text.length() == 0) {
            return text;
        }
        int length = text.length();
        StringBuffer ret = new StringBuffer(length * 12 / 10);
        int last = 0;
        block7: for (int i = 0; i < length; ++i) {
            char c = text.charAt(i);
            if (Character.isISOControl(c) && c != '\t' && c != '\r' && c != '\n') {
                last = JRStringUtil.appendText(text, ret, i, last);
                if (invalidCharReplacement == null) {
                    ret.append(c);
                    continue;
                }
                if ("".equals(invalidCharReplacement)) continue;
                ret.append(invalidCharReplacement);
                continue;
            }
            switch (c) {
                case '&': {
                    last = JRStringUtil.appendText(text, ret, i, last);
                    ret.append("&amp;");
                    continue block7;
                }
                case '>': {
                    last = JRStringUtil.appendText(text, ret, i, last);
                    ret.append("&gt;");
                    continue block7;
                }
                case '<': {
                    last = JRStringUtil.appendText(text, ret, i, last);
                    ret.append("&lt;");
                    continue block7;
                }
                case '\"': {
                    last = JRStringUtil.appendText(text, ret, i, last);
                    ret.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    last = JRStringUtil.appendText(text, ret, i, last);
                    ret.append("&apos;");
                    continue block7;
                }
            }
        }
        JRStringUtil.appendText(text, ret, length, last);
        return ret.toString();
    }

    private static int appendText(String text, StringBuffer ret, int current, int old) {
        if (old < current) {
            ret.append(text.substring(old, current));
        }
        return current + 1;
    }

    public static String htmlEncode(String text) {
        if (text == null || text.length() == 0) {
            return text;
        }
        int length = text.length();
        StringBuffer ret = new StringBuffer(length * 12 / 10);
        boolean isEncodeSpace = true;
        int last = 0;
        block8: for (int i = 0; i < length; ++i) {
            char c = text.charAt(i);
            switch (c) {
                case ' ': {
                    if (isEncodeSpace) {
                        if (last < i) {
                            ret.append(text.substring(last, i));
                        }
                        last = i + 1;
                        ret.append("&nbsp;");
                        isEncodeSpace = false;
                        continue block8;
                    }
                    isEncodeSpace = true;
                    continue block8;
                }
                case '&': {
                    if (last < i) {
                        ret.append(text.substring(last, i));
                    }
                    last = i + 1;
                    ret.append("&amp;");
                    isEncodeSpace = false;
                    continue block8;
                }
                case '>': {
                    if (last < i) {
                        ret.append(text.substring(last, i));
                    }
                    last = i + 1;
                    ret.append("&gt;");
                    isEncodeSpace = false;
                    continue block8;
                }
                case '<': {
                    if (last < i) {
                        ret.append(text.substring(last, i));
                    }
                    last = i + 1;
                    ret.append("&lt;");
                    isEncodeSpace = false;
                    continue block8;
                }
                case '\"': {
                    if (last < i) {
                        ret.append(text.substring(last, i));
                    }
                    last = i + 1;
                    ret.append("&quot;");
                    isEncodeSpace = false;
                    continue block8;
                }
                case '\n': {
                    if (last < i) {
                        ret.append(text.substring(last, i));
                    }
                    last = i + 1;
                    ret.append("<br/>");
                    isEncodeSpace = false;
                    continue block8;
                }
                default: {
                    isEncodeSpace = false;
                }
            }
        }
        if (last < length) {
            ret.append(text.substring(last));
        }
        return ret.toString();
    }

    public static String getJavaIdentifier(String name) {
        if (JRStringUtil.isValidJavaIdentifier(name)) {
            return name;
        }
        StringBuffer buffer = new StringBuffer(name.length() + 5);
        char[] literalChars = new char[name.length()];
        name.getChars(0, literalChars.length, literalChars, 0);
        for (int i = 0; i < literalChars.length; ++i) {
            if (i == 0 && !Character.isJavaIdentifierStart(literalChars[i])) {
                buffer.append(JAVA_IDENTIFIER_PREFIX);
                buffer.append((int)literalChars[i]);
                continue;
            }
            if (i != 0 && !Character.isJavaIdentifierPart(literalChars[i])) {
                buffer.append((int)literalChars[i]);
                continue;
            }
            buffer.append(literalChars[i]);
        }
        return buffer.toString();
    }

    private static boolean isValidJavaIdentifier(String literal) {
        boolean result = true;
        char[] literalChars = new char[literal.length()];
        literal.getChars(0, literalChars.length, literalChars, 0);
        for (int i = 0; i < literalChars.length; ++i) {
            if (i == 0 && !Character.isJavaIdentifierStart(literalChars[i])) {
                result = false;
                break;
            }
            if (i == 0 || Character.isJavaIdentifierPart(literalChars[i])) continue;
            result = false;
            break;
        }
        return result;
    }

    public static String escapeJavaStringLiteral(String text) {
        if (text == null) {
            return text;
        }
        StringBuffer sbuffer = new StringBuffer();
        StringTokenizer tkzer = new StringTokenizer(text, "\\\"\n\r\t", true);
        while (tkzer.hasMoreTokens()) {
            String token = tkzer.nextToken();
            if ("\\".equals(token)) {
                sbuffer.append("\\\\");
                continue;
            }
            if ("\"".equals(token)) {
                sbuffer.append("\\\"");
                continue;
            }
            if ("\n".equals(token)) {
                sbuffer.append("\\n");
                continue;
            }
            if ("\r".equals(token)) {
                sbuffer.append("\\r");
                continue;
            }
            if ("\t".equals(token)) {
                sbuffer.append("\\t");
                continue;
            }
            sbuffer.append(token);
        }
        return sbuffer.toString();
    }

    public static String escapeJavaScript(String input) {
        if (input == null) {
            return input;
        }
        StringBuilder filtered = new StringBuilder(input.length());
        char prevChar = '\u0000';
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == '\"') {
                filtered.append("\\\"");
            } else if (c == '\'') {
                filtered.append("\\'");
            } else if (c == '\\') {
                filtered.append("\\\\");
            } else if (c == '/') {
                filtered.append("\\/");
            } else if (c == '\t') {
                filtered.append("\\t");
            } else if (c == '\n') {
                if (prevChar != '\r') {
                    filtered.append("\\n");
                }
            } else if (c == '\r') {
                filtered.append("\\n");
            } else if (c == '\f') {
                filtered.append("\\f");
            } else {
                filtered.append(c);
            }
            prevChar = c;
        }
        return filtered.toString();
    }

    public static List<Integer> getTabIndexes(String text) {
        ArrayList<Integer> tabIndexes = null;
        if (text != null) {
            tabIndexes = new ArrayList<Integer>();
            for (int i = 0; i < text.length(); ++i) {
                if (text.charAt(i) != '\t') continue;
                tabIndexes.add(i);
            }
        }
        return tabIndexes;
    }

    public static String getString(Object value) {
        return value == null ? null : value.toString();
    }

    private JRStringUtil() {
    }
}

