/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.io.IOException;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.CutsInfo;
import net.sf.jasperreports.engine.export.JRAbstractCsvExporter;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.JRGridLayout;
import net.sf.jasperreports.engine.util.JRStyledText;

public class JRCsvExporter
extends JRAbstractCsvExporter {
    public JRCsvExporter() {
        this(DefaultJasperReportsContext.getInstance());
    }

    public JRCsvExporter(JasperReportsContext jasperReportsContext) {
        super(jasperReportsContext);
    }

    @Override
    protected void exportPage(JRPrintPage page) throws IOException {
        JRGridLayout layout = new JRGridLayout(this.nature, page.getElements(), this.jasperPrint.getPageWidth(), this.jasperPrint.getPageHeight(), this.globalOffsetX, this.globalOffsetY, null);
        JRExporterGridCell[][] grid = layout.getGrid();
        CutsInfo xCuts = layout.getXCuts();
        CutsInfo yCuts = layout.getYCuts();
        StringBuffer rowbuffer = null;
        JRPrintElement element = null;
        String text = null;
        boolean isFirstColumn = true;
        for (int y = 0; y < grid.length; ++y) {
            rowbuffer = new StringBuffer();
            if (!yCuts.isCutNotEmpty(y)) continue;
            isFirstColumn = true;
            for (int x = 0; x < grid[y].length; ++x) {
                if (grid[y][x].getWrapper() != null) {
                    element = grid[y][x].getWrapper().getElement();
                    if (!(element instanceof JRPrintText)) continue;
                    JRStyledText styledText = this.getStyledText((JRPrintText)element);
                    text = styledText == null ? "" : styledText.getText();
                    if (!isFirstColumn) {
                        rowbuffer.append(this.delimiter);
                    }
                    rowbuffer.append(this.prepareText(text));
                    isFirstColumn = false;
                    continue;
                }
                if (!xCuts.isCutNotEmpty(x)) continue;
                if (!isFirstColumn) {
                    rowbuffer.append(this.delimiter);
                }
                isFirstColumn = false;
            }
            if (rowbuffer.length() <= 0) continue;
            this.writer.write(rowbuffer.toString());
            this.writer.write(this.recordDelimiter);
        }
        if (this.progressMonitor != null) {
            this.progressMonitor.afterPageExport();
        }
    }
}

