/*
 * Decompiled with CFR 0.152.
 */
package javaewah;

public final class RunningLengthWord {
    public long[] array;
    public int position;
    public static final int runninglengthbits = 32;
    public static final int literalbits = 31;
    public static final long largestliteralcount = Integer.MAX_VALUE;
    public static final long largestrunninglengthcount = 0xFFFFFFFFL;
    public static final long shiftedlargestrunninglengthcount = 0x1FFFFFFFEL;
    public static final long notshiftedlargestrunninglengthcount = -8589934591L;
    public static final long runninglengthplusrunningbit = 0x1FFFFFFFFL;
    public static final long notrunninglengthplusrunningbit = -8589934592L;
    public static final long notlargestrunninglengthcount = -4294967296L;

    RunningLengthWord(long[] a, int p) {
        this.array = a;
        this.position = p;
    }

    public int getNumberOfLiteralWords() {
        return (int)(this.array[this.position] >>> 33);
    }

    public void setNumberOfLiteralWords(long number) {
        int n = this.position;
        this.array[n] = this.array[n] | 0xFFFFFFFE00000000L;
        int n2 = this.position;
        this.array[n2] = this.array[n2] & (number << 33 | 0x1FFFFFFFFL);
    }

    public void setRunningBit(boolean b) {
        if (b) {
            int n = this.position;
            this.array[n] = this.array[n] | 1L;
        } else {
            int n = this.position;
            this.array[n] = this.array[n] & 0xFFFFFFFFFFFFFFFEL;
        }
    }

    public boolean getRunningBit() {
        return (this.array[this.position] & 1L) != 0L;
    }

    public long getRunningLength() {
        return this.array[this.position] >>> 1 & 0xFFFFFFFFL;
    }

    public void setRunningLength(long number) {
        int n = this.position;
        this.array[n] = this.array[n] | 0x1FFFFFFFEL;
        int n2 = this.position;
        this.array[n2] = this.array[n2] & (number << 1 | 0xFFFFFFFE00000001L);
    }

    public long size() {
        return this.getRunningLength() + (long)this.getNumberOfLiteralWords();
    }

    public String toString() {
        return "running bit = " + this.getRunningBit() + " running length = " + this.getRunningLength() + " number of lit. words " + this.getNumberOfLiteralWords();
    }
}

