/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.expressions.annotations;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.expressions.annotations.JRExprFunction;
import net.sf.jasperreports.expressions.annotations.JRExprFunctionBean;
import net.sf.jasperreports.expressions.annotations.JRExprFunctionCategories;
import net.sf.jasperreports.expressions.annotations.JRExprFunctionParameter;
import net.sf.jasperreports.expressions.annotations.JRExprFunctionParameterBean;
import net.sf.jasperreports.expressions.annotations.JRExprFunctionParameters;

public final class JRExprAnnotationsUtils {
    public static List<JRExprFunctionBean> getJRFunctionsList(Class<?> clazz) {
        Map<String, List<Method>> methodsCache = JRExprAnnotationsUtils.buildAnnotatedMethodsCache(clazz);
        ArrayList<JRExprFunctionBean> functionsList = new ArrayList<JRExprFunctionBean>();
        for (String functionName : methodsCache.keySet()) {
            JRExprFunctionBean jrFunction = JRExprAnnotationsUtils.createJRFunction(methodsCache.get(functionName), clazz.getCanonicalName());
            functionsList.add(jrFunction);
        }
        return functionsList;
    }

    private static JRExprFunctionBean createJRFunction(List<Method> methods, String functionClassName) {
        JRExprFunctionBean funct = new JRExprFunctionBean(functionClassName);
        Method first = methods.get(0);
        JRExprFunction functionAnnotation = first.getAnnotation(JRExprFunction.class);
        funct.setName(first.getName());
        funct.setDisplayName(functionAnnotation.name());
        funct.setDescription(functionAnnotation.description());
        funct.setReturnType(first.getReturnType());
        JRExprFunctionCategories functionCategoriesAnnotation = first.getAnnotation(JRExprFunctionCategories.class);
        funct.getCategories().addAll(Arrays.asList(functionCategoriesAnnotation.value()));
        JRExprFunctionParameters parametersAnnotation = first.getAnnotation(JRExprFunctionParameters.class);
        if (parametersAnnotation != null) {
            for (JRExprFunctionParameter param : parametersAnnotation.value()) {
                JRExprFunctionParameterBean paramDescriptor = new JRExprFunctionParameterBean();
                paramDescriptor.setName(param.name());
                paramDescriptor.setDescription(param.description());
                funct.getParameters().add(paramDescriptor);
            }
        }
        int paramIndex = 0;
        int paramsNum = funct.getParameters().size();
        for (int i = 0; i < methods.size() && paramIndex < paramsNum; ++i) {
            Method currMethod = methods.get(i);
            Class<?>[] parameterTypes = currMethod.getParameterTypes();
            boolean isOptional = i != 0;
            int j = paramIndex;
            while (j < parameterTypes.length) {
                boolean isMulti = parameterTypes[j].isArray();
                JRExprFunctionParameterBean paramFunctBean = funct.getParameters().get(paramIndex);
                if (paramFunctBean != null) {
                    paramFunctBean.setOptional(isOptional);
                    paramFunctBean.setMulti(isMulti);
                    paramFunctBean.setParameterType(parameterTypes[j]);
                }
                ++j;
                ++paramIndex;
            }
        }
        return funct;
    }

    private static Map<String, List<Method>> buildAnnotatedMethodsCache(Class<?> clazz) {
        List<Method> methods;
        String methodName;
        JRExprFunction jrFunctionAnn;
        HashMap<String, List<Method>> methodsByNameMap = new HashMap<String, List<Method>>();
        for (Method m : clazz.getMethods()) {
            jrFunctionAnn = m.getAnnotation(JRExprFunction.class);
            if (jrFunctionAnn == null) continue;
            methodName = m.getName();
            methods = (ArrayList<Method>)methodsByNameMap.get(methodName);
            if (methods == null) {
                methods = new ArrayList<Method>();
            }
            methods.add(m);
            methodsByNameMap.put(methodName, methods);
        }
        for (Method m : clazz.getMethods()) {
            jrFunctionAnn = m.getAnnotation(JRExprFunction.class);
            if (jrFunctionAnn != null || (methods = (List)methodsByNameMap.get(methodName = m.getName())) == null) continue;
            methods.add(m);
        }
        return methodsByNameMap;
    }
}

