/*
 * iReport - Visual Designer for JasperReports.
 * Copyright (C) 2002 - 2009 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com
 *
 * Unless you have purchased a commercial license agreement from Jaspersoft,
 * the following license terms apply:
 *
 * This program is part of iReport.
 *
 * iReport is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * iReport is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with iReport. If not, see <http://www.gnu.org/licenses/>.
 */
package com.jaspersoft.ireport.jasperserver.ui.inputcontrols.impl;

import java.awt.event.ActionListener;

/**
 *
 * @author  gtoffoli
 */
public class BasicInputControlUI extends javax.swing.JPanel implements InputControlUI {

    /** Creates new form BasicInputControlUI */
    public BasicInputControlUI() {
        initComponents();
    }
    
    public Object getValue()
    {
        return getJComboBoxValue().getSelectedItem();
    }
    
    public void setValue(Object v)
    {
        for (int i=0; i<getJComboBoxValue().getItemCount(); ++i)
        {
            Object val = getJComboBoxValue().getItemAt(i);
            if (val.equals( v))
            {
                getJComboBoxValue().setSelectedIndex(i);
                return;
            }
        }
        
        getJComboBoxValue().setSelectedItem(v);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jLabelName = new javax.swing.JLabel();
        jComboBoxValue = new javax.swing.JComboBox();

        setLayout(new java.awt.GridBagLayout());

        setPreferredSize(new java.awt.Dimension(250, 40));
        jLabelName.setText("jLabel1");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 0, 4);
        add(jLabelName, gridBagConstraints);

        jComboBoxValue.setEditable(true);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 14, 0, 4);
        add(jComboBoxValue, gridBagConstraints);

    }// </editor-fold>//GEN-END:initComponents
    
    public void setLabel(String lbl)
    {
        this.jLabelName.setText(lbl);
    }
    
    public void setHistory(java.util.List values){
        
        getJComboBoxValue().removeAllItems();
        if (values == null) return;
        for (int i=0; i<values.size(); ++i)
        {
            getJComboBoxValue().addItem( values.get(i));
        }
        
        if (getJComboBoxValue().getItemCount() > 0)
        {
            getJComboBoxValue().setSelectedIndex(0);
        }
        
        getJComboBoxValue().updateUI();
    }
    
    public void setComboEditable(boolean b)
    {
        getJComboBoxValue().setEditable(b);
    }
    
    public boolean getComboEditable()
    {
        return getJComboBoxValue().isEditable();
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JComboBox jComboBoxValue;
    private javax.swing.JLabel jLabelName;
    // End of variables declaration//GEN-END:variables
    
    public void setReadOnly( boolean b )
    {
        jLabelName.setEnabled(!b);
        getJComboBoxValue().setEnabled(!b);
    }

    public javax.swing.JComboBox getJComboBoxValue() {
        return jComboBoxValue;
    }

    public void setJComboBoxValue(javax.swing.JComboBox jComboBoxValue) {
        this.jComboBoxValue = jComboBoxValue;
    }

    public void addActionListener(ActionListener listener) {
        jComboBoxValue.addActionListener(listener);
    }

}
