/*
 * Decompiled with CFR 0.152.
 */
package rex.graphics.mdxeditor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import rex.utils.I18n;
import rex.utils.LanguageChangedEvent;
import rex.utils.LanguageChangedListener;

public class NewMemberOrSetDialog
extends JDialog
implements ActionListener,
LanguageChangedListener {
    JTextField caption;
    private String selected;
    JButton jb;
    JLabel lblName;
    public static String MEMBERS_SELECTED = "MEMBER_SELECTED";
    public static String SET_SELECTED = "SET_SELECTED";

    public NewMemberOrSetDialog(JDialog owner) {
        super((Frame)null, "Member or set?", true);
        JPanel jp = new JPanel(new GridLayout(2, 2));
        JRadioButton memberButton = new JRadioButton("Member");
        memberButton.setActionCommand(MEMBERS_SELECTED);
        memberButton.addActionListener(this);
        memberButton.setSelected(true);
        JRadioButton setButton = new JRadioButton("Set");
        setButton.setActionCommand(SET_SELECTED);
        setButton.addActionListener(this);
        ButtonGroup group = new ButtonGroup();
        group.add(memberButton);
        group.add(setButton);
        this.selected = MEMBERS_SELECTED;
        this.caption = new JTextField();
        this.caption.setBackground(Color.white);
        jp.add(memberButton);
        jp.add(setButton);
        this.lblName = new JLabel(I18n.getString("label.name"));
        jp.add(this.lblName);
        jp.add(this.caption);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)jp, "Center");
        this.jb = new JButton(I18n.getString("btn.ok"));
        this.jb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewMemberOrSetDialog.this.removeLanguageListener();
                NewMemberOrSetDialog.this.dispose();
            }
        });
        this.getContentPane().add((Component)this.jb, "South");
        Dimension sd = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(sd.width / 2 - 125, sd.height / 2 - 60);
        this.setResizable(false);
        I18n.addOnLanguageChangedListener(this);
        this.applyI18n();
        this.setSize(250, 120);
        this.setVisible(true);
    }

    @Override
    public String getName() {
        return this.caption.getText().trim();
    }

    public String selected() {
        return this.selected;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.selected = e.getActionCommand();
    }

    public static void main(String[] args) {
        NewMemberOrSetDialog testDialog = new NewMemberOrSetDialog(null);
    }

    @Override
    public void languageChanged(LanguageChangedEvent evt) {
        this.applyI18n();
    }

    @Override
    public void removeLanguageListener() {
        I18n.removeOnLanguageChangedListener(this);
    }

    public void applyI18n() {
        this.lblName.setText(I18n.getString("label.name"));
        this.jb.setText(I18n.getString("btn.ok"));
    }
}

