/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.repo;

import net.sf.jasperreports.data.DataAdapter;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.repo.CastorDataAdapterPersistenceService;
import net.sf.jasperreports.repo.DefaultRepositoryService;
import net.sf.jasperreports.repo.InputStreamPersistenceService;
import net.sf.jasperreports.repo.InputStreamResource;
import net.sf.jasperreports.repo.OutputStreamPersistenceService;
import net.sf.jasperreports.repo.OutputStreamResource;
import net.sf.jasperreports.repo.PersistenceService;
import net.sf.jasperreports.repo.PersistenceServiceFactory;
import net.sf.jasperreports.repo.ReportResource;
import net.sf.jasperreports.repo.RepositoryService;
import net.sf.jasperreports.repo.Resource;
import net.sf.jasperreports.repo.SerializedObjectPersistenceService;
import net.sf.jasperreports.repo.SerializedReportPersistenceService;

public class DefaultRepositoryPersistenceServiceFactory
implements PersistenceServiceFactory {
    private static final DefaultRepositoryPersistenceServiceFactory INSTANCE = new DefaultRepositoryPersistenceServiceFactory();

    public static DefaultRepositoryPersistenceServiceFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public <K extends RepositoryService, L extends Resource, M extends PersistenceService> M getPersistenceService(JasperReportsContext jasperReportsContext, Class<K> repositoryServiceType, Class<L> resourceType) {
        if (DefaultRepositoryService.class.getName().equals(repositoryServiceType.getName())) {
            if (InputStreamResource.class.getName().equals(resourceType.getName())) {
                return (M)new InputStreamPersistenceService();
            }
            if (OutputStreamResource.class.getName().equals(resourceType.getName())) {
                return (M)new OutputStreamPersistenceService();
            }
            if (ReportResource.class.getName().equals(resourceType.getName())) {
                return (M)new SerializedReportPersistenceService();
            }
            if (DataAdapter.class.isAssignableFrom(resourceType)) {
                return (M)new CastorDataAdapterPersistenceService(jasperReportsContext);
            }
            return (M)new SerializedObjectPersistenceService();
        }
        return null;
    }

    @Override
    public <K extends RepositoryService, L extends Resource, M extends PersistenceService> M getPersistenceService(Class<K> repositoryServiceType, Class<L> resourceType) {
        return this.getPersistenceService(DefaultJasperReportsContext.getInstance(), repositoryServiceType, resourceType);
    }
}

