/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.sql;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import mondrian.olap.MondrianDef;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Util;
import mondrian.rolap.RolapStar;
import mondrian.rolap.RolapUtil;
import mondrian.spi.Dialect;
import mondrian.spi.DialectManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlQuery {
    private final boolean generateFormattedSql;
    private boolean distinct;
    private final ClauseList select;
    private final ClauseList from;
    private final ClauseList where;
    private final ClauseList groupBy;
    private final ClauseList having;
    private final ClauseList orderBy;
    private final List<ClauseList> groupingSet;
    private final ClauseList groupingFunction;
    private boolean allowHints;
    private final List<String> fromAliases;
    private final Dialect dialect;
    private final StringBuilder buf;

    public SqlQuery(Dialect dialect, boolean formatted) {
        assert (dialect != null);
        this.generateFormattedSql = formatted;
        this.select = new ClauseList(true);
        this.from = new ClauseList(true);
        this.groupingFunction = new ClauseList(false);
        this.where = new ClauseList(false);
        this.groupBy = new ClauseList(false);
        this.having = new ClauseList(false);
        this.orderBy = new ClauseList(false);
        this.fromAliases = new ArrayList<String>();
        this.buf = new StringBuilder(128);
        this.groupingSet = new ArrayList<ClauseList>();
        this.dialect = dialect;
        this.allowHints = false;
    }

    public SqlQuery(Dialect dialect) {
        this(dialect, MondrianProperties.instance().GenerateFormattedSql.get());
    }

    public SqlQuery cloneEmpty() {
        return new SqlQuery(this.dialect);
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public void setAllowHints(boolean t) {
        this.allowHints = t;
    }

    public boolean addFromQuery(String query, String alias, boolean failIfExists) {
        assert (alias != null);
        if (this.fromAliases.contains(alias)) {
            if (failIfExists) {
                throw Util.newInternal("query already contains alias '" + alias + "'");
            }
            return false;
        }
        this.buf.setLength(0);
        this.buf.append('(');
        this.buf.append(query);
        this.buf.append(')');
        if (alias != null) {
            Util.assertTrue(alias.length() > 0);
            if (this.dialect.allowsAs()) {
                this.buf.append(" as ");
            } else {
                this.buf.append(' ');
            }
            this.dialect.quoteIdentifier(alias, this.buf);
            this.fromAliases.add(alias);
        }
        this.from.add(this.buf.toString());
        return true;
    }

    boolean addFromTable(String schema, String name, String alias, String filter, Map hints, boolean failIfExists) {
        if (this.fromAliases.contains(alias)) {
            if (failIfExists) {
                throw Util.newInternal("query already contains alias '" + alias + "'");
            }
            return false;
        }
        this.buf.setLength(0);
        this.dialect.quoteIdentifier(this.buf, schema, name);
        if (alias != null) {
            Util.assertTrue(alias.length() > 0);
            if (this.dialect.allowsAs()) {
                this.buf.append(" as ");
            } else {
                this.buf.append(' ');
            }
            this.dialect.quoteIdentifier(alias, this.buf);
            this.fromAliases.add(alias);
        }
        if (this.allowHints) {
            this.dialect.appendHintsAfterFromClause(this.buf, hints);
        }
        this.from.add(this.buf.toString());
        if (filter != null) {
            this.addWhere("(", filter, ")");
        }
        return true;
    }

    public void addFrom(SqlQuery sqlQuery, String alias, boolean failIfExists) {
        this.addFromQuery(sqlQuery.toString(), alias, failIfExists);
    }

    public boolean addFrom(MondrianDef.RelationOrJoin relation, String alias, boolean failIfExists) {
        if (relation instanceof MondrianDef.View) {
            MondrianDef.View view = (MondrianDef.View)relation;
            String viewAlias = alias == null ? view.getAlias() : alias;
            String sqlString = view.getCodeSet().chooseQuery(this.dialect);
            return this.addFromQuery(sqlString, viewAlias, false);
        }
        if (relation instanceof MondrianDef.InlineTable) {
            MondrianDef.Relation relation1 = RolapUtil.convertInlineTableToRelation((MondrianDef.InlineTable)relation, this.dialect);
            return this.addFrom(relation1, alias, failIfExists);
        }
        if (relation instanceof MondrianDef.Table) {
            MondrianDef.Table table = (MondrianDef.Table)relation;
            String tableAlias = alias == null ? table.getAlias() : alias;
            return this.addFromTable(table.schema, table.name, tableAlias, table.getFilter(), table.getHintMap(), failIfExists);
        }
        if (relation instanceof MondrianDef.Join) {
            boolean added;
            MondrianDef.Join join = (MondrianDef.Join)relation;
            String leftAlias = join.getLeftAlias();
            String rightAlias = join.getRightAlias();
            boolean addLeft = this.addFrom(join.left, leftAlias, failIfExists);
            boolean addRight = this.addFrom(join.right, rightAlias, failIfExists);
            boolean bl = added = addLeft || addRight;
            if (added) {
                this.buf.setLength(0);
                this.dialect.quoteIdentifier(this.buf, leftAlias, join.leftKey);
                this.buf.append(" = ");
                this.dialect.quoteIdentifier(this.buf, rightAlias, join.rightKey);
                this.addWhere(this.buf.toString());
            }
            return added;
        }
        throw Util.newInternal("bad relation type " + (Object)((Object)relation));
    }

    public String addSelect(String expression) {
        switch (this.dialect.getDatabaseProduct()) {
            case DB2_AS400: 
            case DERBY: {
                return this.addSelect(expression, null);
            }
        }
        return this.addSelect(expression, this.nextColumnAlias());
    }

    public String addSelectGroupBy(String expression) {
        String alias = this.addSelect(expression);
        this.addGroupBy(expression, alias);
        return alias;
    }

    public int getCurrentSelectListSize() {
        return this.select.size();
    }

    public String nextColumnAlias() {
        return "c" + this.select.size();
    }

    public String addSelect(String expression, String alias) {
        this.buf.setLength(0);
        this.buf.append(expression);
        if (alias != null) {
            this.buf.append(" as ");
            this.dialect.quoteIdentifier(alias, this.buf);
        }
        this.select.add(this.buf.toString());
        return alias;
    }

    public void addWhere(String exprLeft, String exprMid, String exprRight) {
        int len = exprLeft.length() + exprMid.length() + exprRight.length();
        StringBuilder buf = new StringBuilder(len);
        buf.append(exprLeft);
        buf.append(exprMid);
        buf.append(exprRight);
        this.addWhere(buf.toString());
    }

    public void addWhere(RolapStar.Condition joinCondition) {
        String left = joinCondition.getLeft().getTableAlias();
        String right = joinCondition.getRight().getTableAlias();
        if (this.fromAliases.contains(left) && this.fromAliases.contains(right)) {
            this.addWhere(joinCondition.getLeft(this), " = ", joinCondition.getRight(this));
        }
    }

    public void addWhere(String expression) {
        this.where.add(expression);
    }

    public void addGroupBy(String expression) {
        this.groupBy.add(expression);
    }

    public void addGroupBy(String expression, String alias) {
        if (this.dialect.requiresGroupByAlias()) {
            this.addGroupBy(this.dialect.quoteIdentifier(alias));
        } else {
            this.addGroupBy(expression);
        }
    }

    public void addHaving(String expression) {
        this.having.add(expression);
    }

    public void addOrderBy(String expr, boolean ascending, boolean prepend, boolean nullable) {
        String orderExpr = this.dialect.generateOrderItem(expr, nullable, ascending);
        if (prepend) {
            this.orderBy.add(0, orderExpr);
        } else {
            this.orderBy.add(orderExpr);
        }
    }

    public String toString() {
        if (this.generateFormattedSql) {
            StringWriter sw = new StringWriter(256);
            PrintWriter pw = new PrintWriter(sw);
            this.print(pw, "");
            pw.flush();
            return sw.toString();
        }
        this.buf.setLength(0);
        this.select.toBuffer(this.buf, this.distinct ? "select distinct " : "select ", ", ");
        this.buf.append(this.getGroupingFunction(""));
        this.from.toBuffer(this.buf, " from ", ", ");
        this.where.toBuffer(this.buf, " where ", " and ");
        if (this.hasGroupingSet()) {
            StringWriter stringWriter = new StringWriter();
            this.printGroupingSets(new PrintWriter(stringWriter), "");
            this.buf.append(stringWriter.toString());
        } else {
            this.groupBy.toBuffer(this.buf, " group by ", ", ");
        }
        this.having.toBuffer(this.buf, " having ", " and ");
        this.orderBy.toBuffer(this.buf, " order by ", ", ");
        return this.buf.toString();
    }

    public void print(PrintWriter pw, String prefix) {
        this.select.print(pw, this.generateFormattedSql, prefix, this.distinct ? "select distinct " : "select ", ", ");
        pw.print(this.getGroupingFunction(prefix));
        this.from.print(pw, this.generateFormattedSql, prefix, "from ", ", ");
        this.where.print(pw, this.generateFormattedSql, prefix, "where ", " and ");
        if (this.hasGroupingSet()) {
            this.printGroupingSets(pw, prefix);
        } else {
            this.groupBy.print(pw, this.generateFormattedSql, prefix, "group by ", ", ");
        }
        this.having.print(pw, this.generateFormattedSql, prefix, "having ", " and ");
        this.orderBy.print(pw, this.generateFormattedSql, prefix, "order by ", ", ");
    }

    private String getGroupingFunction(String prefix) {
        if (!this.hasGroupingSet()) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.groupingFunction.size(); ++i) {
            if (this.generateFormattedSql) {
                buf.append("    ").append(prefix);
            }
            buf.append(", ");
            buf.append("grouping(");
            buf.append((String)this.groupingFunction.get(i));
            buf.append(") as ");
            this.dialect.quoteIdentifier("g" + i, buf);
            if (!this.generateFormattedSql) continue;
            buf.append(Util.nl);
        }
        return buf.toString();
    }

    private void printGroupingSets(PrintWriter pw, String prefix) {
        pw.print(" group by grouping sets (");
        for (int i = 0; i < this.groupingSet.size(); ++i) {
            if (i > 0) {
                pw.print(",");
            }
            pw.print("(");
            this.groupingSet.get(i).print(pw, this.generateFormattedSql, prefix, "", ",", "", "");
            pw.print(")");
        }
        pw.print(")");
    }

    private boolean hasGroupingSet() {
        return !this.groupingSet.isEmpty();
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public static SqlQuery newQuery(DataSource dataSource, String err) {
        Dialect dialect = DialectManager.createDialect(dataSource, null);
        return new SqlQuery(dialect);
    }

    public void addGroupingSet(List<String> groupingColumnsExpr) {
        ClauseList groupingList = new ClauseList(false);
        for (String columnExp : groupingColumnsExpr) {
            groupingList.add(columnExp);
        }
        this.groupingSet.add(groupingList);
    }

    public void addGroupingFunction(String columnExpr) {
        this.groupingFunction.add(columnExpr);
    }

    public static class CodeSet {
        private final Map<String, String> dialectCodes = new HashMap<String, String>();

        public String put(String dialect, String code) {
            return this.dialectCodes.put(dialect, code);
        }

        public String chooseQuery(Dialect dialect) {
            String best = CodeSet.getBestName(dialect);
            String bestCode = this.dialectCodes.get(best);
            if (bestCode != null) {
                return bestCode;
            }
            String genericCode = this.dialectCodes.get("generic");
            if (genericCode == null) {
                throw Util.newError("View has no 'generic' variant");
            }
            return genericCode;
        }

        private static String getBestName(Dialect dialect) {
            return dialect.getDatabaseProduct().getFamily().name().toLowerCase();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ClauseList
    extends ArrayList<String> {
        private final boolean allowDups;

        ClauseList(boolean allowDups) {
            this.allowDups = allowDups;
        }

        @Override
        public boolean add(String element) {
            if (this.allowDups || !this.contains(element)) {
                return super.add(element);
            }
            return false;
        }

        void toBuffer(StringBuilder buf, String first, String sep) {
            boolean firstTime = true;
            for (String s : this) {
                if (firstTime) {
                    buf.append(first);
                    firstTime = false;
                } else {
                    buf.append(sep);
                }
                buf.append(s);
            }
        }

        void print(PrintWriter pw, boolean generateFormattedSql, String prefix, String first, String sep) {
            this.print(pw, generateFormattedSql, prefix, first, sep, "", "");
        }

        void print(PrintWriter pw, boolean generateFormattedSql, String prefix, String first, String sep, String suffix, String last) {
            String subprefix = prefix + "    ";
            boolean firstTime = true;
            for (String s : this) {
                if (firstTime) {
                    if (generateFormattedSql) {
                        pw.print(prefix);
                    }
                    pw.print(first);
                    firstTime = false;
                } else {
                    pw.print(sep);
                }
                if (generateFormattedSql) {
                    pw.println();
                    pw.print(subprefix);
                }
                pw.print(s);
                if (!generateFormattedSql) continue;
                pw.print(suffix);
            }
            pw.print(last);
            if (!firstTime && generateFormattedSql) {
                pw.println();
            }
        }
    }
}

