/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;

public interface DataTransferProtocol {
    public static final int DATA_TRANSFER_VERSION = 17;
    public static final byte OP_WRITE_BLOCK = 80;
    public static final byte OP_READ_BLOCK = 81;
    @Deprecated
    public static final byte OP_READ_METADATA = 82;
    public static final byte OP_REPLACE_BLOCK = 83;
    public static final byte OP_COPY_BLOCK = 84;
    public static final byte OP_BLOCK_CHECKSUM = 85;
    public static final int OP_STATUS_SUCCESS = 0;
    public static final int OP_STATUS_ERROR = 1;
    public static final int OP_STATUS_ERROR_CHECKSUM = 2;
    public static final int OP_STATUS_ERROR_INVALID = 3;
    public static final int OP_STATUS_ERROR_EXISTS = 4;
    public static final int OP_STATUS_ERROR_ACCESS_TOKEN = 5;
    public static final int OP_STATUS_CHECKSUM_OK = 6;

    public static class PipelineAck
    implements Writable {
        private long seqno;
        private short[] replies;
        public static final long UNKOWN_SEQNO = -2L;

        public PipelineAck() {
        }

        public PipelineAck(long seqno, short[] replies) {
            this.seqno = seqno;
            this.replies = replies;
        }

        public long getSeqno() {
            return this.seqno;
        }

        public short getNumOfReplies() {
            return (short)this.replies.length;
        }

        public short getReply(int i) {
            return this.replies[i];
        }

        public boolean isSuccess() {
            for (short reply : this.replies) {
                if (reply == 0) continue;
                return false;
            }
            return true;
        }

        @Override
        public void readFields(DataInput in) throws IOException {
            this.seqno = in.readLong();
            int numOfReplies = in.readShort();
            this.replies = new short[numOfReplies];
            for (int i = 0; i < numOfReplies; ++i) {
                this.replies[i] = in.readShort();
            }
        }

        @Override
        public void write(DataOutput out) throws IOException {
            out.writeLong(this.seqno);
            out.writeShort((short)this.replies.length);
            for (short reply : this.replies) {
                out.writeShort(reply);
            }
        }

        public String toString() {
            StringBuilder ack = new StringBuilder("Replies for seqno ");
            ack.append(this.seqno).append(" are");
            for (short reply : this.replies) {
                ack.append(" ");
                if (reply == 0) {
                    ack.append("SUCCESS");
                    continue;
                }
                ack.append("FAILED");
            }
            return ack.toString();
        }
    }
}

