/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.remoting.caucho;

import com.caucho.burlap.io.BurlapInput;
import com.caucho.burlap.io.BurlapOutput;
import com.caucho.burlap.server.BurlapSkeleton;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.remoting.support.RemoteExporter;
import org.springframework.util.Assert;
import org.springframework.web.HttpRequestHandler;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.util.NestedServletException;

public class BurlapServiceExporter
extends RemoteExporter
implements HttpRequestHandler,
InitializingBean {
    private BurlapSkeleton skeleton;

    public void afterPropertiesSet() {
        this.prepare();
    }

    public void prepare() {
        try {
            try {
                Constructor ctor = BurlapSkeleton.class.getConstructor(Object.class, Class.class);
                this.checkService();
                this.checkServiceInterface();
                this.skeleton = (BurlapSkeleton)ctor.newInstance(this.getProxyForService(), this.getServiceInterface());
            }
            catch (NoSuchMethodException ex) {
                Constructor ctor = BurlapSkeleton.class.getConstructor(Object.class);
                this.skeleton = (BurlapSkeleton)ctor.newInstance(this.getProxyForService());
            }
        }
        catch (Exception ex) {
            throw new BeanInitializationException("Burlap skeleton initialization failed", ex);
        }
    }

    public void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Assert.notNull(this.skeleton, "BurlapServiceExporter has not been initialized");
        if (!"POST".equals(request.getMethod())) {
            throw new HttpRequestMethodNotSupportedException("POST", "BurlapServiceExporter only supports POST requests");
        }
        BurlapInput in = new BurlapInput((InputStream)request.getInputStream());
        BurlapOutput out = new BurlapOutput((OutputStream)response.getOutputStream());
        try {
            this.skeleton.invoke(in, out);
        }
        catch (Throwable ex) {
            throw new NestedServletException("Burlap skeleton invocation failed", ex);
        }
    }
}

