/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.objectinspector;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.SettableStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.util.ReflectionUtils;

public class ReflectionStructObjectInspector
extends SettableStructObjectInspector {
    Class<?> objectClass;
    List<MyField> fields;

    @Override
    public ObjectInspector.Category getCategory() {
        return ObjectInspector.Category.STRUCT;
    }

    @Override
    public String getTypeName() {
        return this.objectClass.getName();
    }

    ReflectionStructObjectInspector() {
    }

    void init(Class<?> objectClass, List<ObjectInspector> structFieldObjectInspectors) {
        assert (!List.class.isAssignableFrom(objectClass));
        assert (!Map.class.isAssignableFrom(objectClass));
        this.objectClass = objectClass;
        Field[] reflectionFields = ObjectInspectorUtils.getDeclaredNonStaticFields(objectClass);
        this.fields = new ArrayList<MyField>(structFieldObjectInspectors.size());
        int used = 0;
        for (int i = 0; i < reflectionFields.length; ++i) {
            if (this.shouldIgnoreField(reflectionFields[i].getName())) continue;
            reflectionFields[i].setAccessible(true);
            this.fields.add(new MyField(reflectionFields[i], structFieldObjectInspectors.get(used++)));
        }
        assert (this.fields.size() == structFieldObjectInspectors.size());
    }

    public boolean shouldIgnoreField(String name) {
        return false;
    }

    @Override
    public StructField getStructFieldRef(String fieldName) {
        return ObjectInspectorUtils.getStandardStructFieldRef(fieldName, this.fields);
    }

    @Override
    public List<? extends StructField> getAllStructFieldRefs() {
        return this.fields;
    }

    @Override
    public Object getStructFieldData(Object data, StructField fieldRef) {
        if (data == null) {
            return null;
        }
        if (!(fieldRef instanceof MyField)) {
            throw new RuntimeException("fieldRef has to be of MyField");
        }
        MyField f = (MyField)fieldRef;
        try {
            Object r = f.field.get(data);
            return r;
        }
        catch (Exception e) {
            throw new RuntimeException("cannot get field " + f.field + " from " + data.getClass() + " " + data, e);
        }
    }

    @Override
    public List<Object> getStructFieldsDataAsList(Object data) {
        if (data == null) {
            return null;
        }
        try {
            ArrayList<Object> result = new ArrayList<Object>(this.fields.size());
            for (int i = 0; i < this.fields.size(); ++i) {
                result.add(this.fields.get((int)i).field.get(data));
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Object create() {
        return ReflectionUtils.newInstance(this.objectClass, null);
    }

    @Override
    public Object setStructFieldData(Object struct, StructField field, Object fieldValue) {
        MyField myField = (MyField)field;
        try {
            myField.field.set(struct, fieldValue);
        }
        catch (Exception e) {
            throw new RuntimeException("cannot set field " + myField.field + " of " + struct.getClass() + " " + struct, e);
        }
        return struct;
    }

    public static class MyField
    implements StructField {
        protected Field field;
        protected ObjectInspector fieldObjectInspector;

        public MyField(Field field, ObjectInspector fieldObjectInspector) {
            this.field = field;
            this.fieldObjectInspector = fieldObjectInspector;
        }

        @Override
        public String getFieldName() {
            return this.field.getName().toLowerCase();
        }

        @Override
        public ObjectInspector getFieldObjectInspector() {
            return this.fieldObjectInspector;
        }

        @Override
        public String getFieldComment() {
            return null;
        }

        public String toString() {
            return this.field.toString();
        }
    }
}

