/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public class EvilUnclosedBRFixingInputStream
extends InputStream {
    private InputStream source;
    private byte[] spare;
    private static byte[] detect = new byte[]{60, 98, 114, 62};

    public EvilUnclosedBRFixingInputStream(InputStream source) {
        this.source = source;
    }

    public int read() throws IOException {
        return this.source.read();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.spare != null) {
            System.arraycopy(this.spare, 0, b, off, this.spare.length);
            int ret = this.spare.length;
            this.spare = null;
            return ret;
        }
        int read = this.source.read(b, off, len);
        read = this.fixUp(b, off, read);
        return read;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    private int fixUp(byte[] b, int offset, int read) {
        ArrayList<Integer> fixAt = new ArrayList<Integer>();
        for (int i = offset; i < offset + read - 4; ++i) {
            boolean going = true;
            for (int j = 0; j < detect.length && going; ++j) {
                if (b[i + j] == detect[j]) continue;
                going = false;
            }
            if (!going) continue;
            fixAt.add(i);
        }
        if (fixAt.size() == 0) {
            return read;
        }
        int overshoot = offset + read + fixAt.size() - b.length;
        if (overshoot > 0) {
            this.spare = new byte[overshoot];
            System.arraycopy(b, b.length - overshoot, this.spare, 0, overshoot);
            read -= overshoot;
        }
        for (int j = fixAt.size() - 1; j >= 0; --j) {
            int i = (Integer)fixAt.get(j);
            byte[] tmp = new byte[read - i - 3];
            System.arraycopy(b, i + 3, tmp, 0, tmp.length);
            b[i + 3] = 47;
            System.arraycopy(tmp, 0, b, i + 4, tmp.length);
            ++read;
        }
        return read;
    }
}

