/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.mongodb.jasperserver;

import com.jaspersoft.jasperserver.api.metadata.jasperreports.service.ReportDataSourceService;
import com.jaspersoft.mongodb.connection.MongoDbConnection;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import org.apache.log4j.Logger;
import org.cloudfoundry.runtime.env.CloudEnvironment;
import org.cloudfoundry.runtime.env.MongoServiceInfo;

public class MongoDbCloudFoundryDataSourceService
implements ReportDataSourceService {
    Logger logger = Logger.getLogger(MongoDbCloudFoundryDataSourceService.class);
    private CloudEnvironment cloudEnvironment = new CloudEnvironment();
    private MongoDbConnection connection;
    private String serviceName;

    public void closeConnection() {
        if (this.connection != null) {
            this.connection.close();
        }
    }

    public void setReportParameterValues(Map parameters) {
        if (this.serviceName == null) {
            this.logger.error((Object)"No service name specified");
            return;
        }
        try {
            this.createConnection();
            parameters.put("com.jaspersoft.mongodb.connection", this.connection);
        }
        catch (JRException e) {
            this.logger.error((Object)e);
        }
    }

    private void createConnection() throws JRException {
        MongoServiceInfo mongoServiceInfo = (MongoServiceInfo)this.cloudEnvironment.getServiceInfo(this.serviceName, MongoServiceInfo.class);
        if (mongoServiceInfo == null) {
            this.logger.error((Object)("No mongodb service with name: " + this.serviceName));
            return;
        }
        if (this.connection != null) {
            this.closeConnection();
        }
        this.connection = new MongoDbConnection("mongodb://" + mongoServiceInfo.getHost() + ":" + mongoServiceInfo.getPort() + "/" + mongoServiceInfo.getDatabase(), mongoServiceInfo.getUserName(), mongoServiceInfo.getPassword());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean testConnection() throws JRException {
        try {
            this.createConnection();
            if (this.connection == null) {
                boolean bl = false;
                return bl;
            }
            this.connection.test();
            boolean bl = true;
            return bl;
        }
        finally {
            this.closeConnection();
        }
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getServiceName() {
        return this.serviceName;
    }
}

