/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.mongodb.importer;

import com.jaspersoft.mongodb.connection.MongoDbConnection;
import com.jaspersoft.mongodb.importer.MongoDbImporter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import net.sf.jasperreports.engine.JRException;
import org.apache.log4j.Logger;

public class MongoDbLocalImporter {
    private Properties settings = new Properties();
    private Connection connection;
    private static final Logger logger = Logger.getLogger(MongoDbLocalImporter.class);
    public static final String CHARACTER_SET = "UTF-8";
    private MongoDbConnection mongodbConnection;
    private MongoDbImporter importer;

    public MongoDbLocalImporter() throws Exception {
        this.settings.load(this.getClass().getClassLoader().getResourceAsStream("MongoDbImporter.properties"));
        this.createMongoConnection();
        this.createConnection();
        this.importer = new MongoDbImporter(this.connection, this.mongodbConnection);
    }

    private void createMongoConnection() throws JRException {
        this.mongodbConnection = new MongoDbConnection(this.settings.getProperty("com.jaspersoft.mongodb.uri"), this.settings.getProperty("com.jaspersoft.mongodb.mUser"), this.settings.getProperty("com.jaspersoft.mongodb.mPassword"));
    }

    private void createConnection() throws ClassNotFoundException {
        Class.forName(this.settings.getProperty("com.jaspersoft.mongodb.driver", null));
        try {
            this.connection = DriverManager.getConnection(this.settings.getProperty("com.jaspersoft.mongodb.jdbcURL", null), this.settings.getProperty("com.jaspersoft.mongodb.user", null), this.settings.getProperty("com.jaspersoft.mongodb.password", null));
            logger.info((Object)"Database connection created");
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
    }

    public void shutdown() {
        if (this.mongodbConnection != null) {
            this.mongodbConnection.close();
            this.mongodbConnection = null;
        }
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException e) {
                logger.error((Object)e);
            }
            this.connection = null;
        }
    }

    public void processTable(String tableName) throws Exception {
        this.importer.importTable(tableName);
        this.importer.validate(tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] arguments) throws Exception {
        arguments = new String[]{"accounts"};
        if (arguments.length != 1) {
            System.out.println("Usage: sh importer.sh TABLE_NAME");
            System.out.println("Example: sh impporter.sh accounts");
            return;
        }
        MongoDbLocalImporter localImporter = null;
        try {
            localImporter = new MongoDbLocalImporter();
            localImporter.processTable(arguments[0]);
        }
        finally {
            if (localImporter != null) {
                localImporter.shutdown();
            }
        }
    }
}

