/*
 * Decompiled with CFR 0.152.
 */
package net.sf.nsisant;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.sf.nsisant.Define;
import net.sf.nsisant.Scriptcmd;
import net.sf.nsisant.Verbosity;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.types.Commandline;

public class Task
extends org.apache.tools.ant.Task {
    protected static final String NSIS_CMD_LINE = "makensis";
    protected static final String NSIS_OPT_VERBOSITY = "V";
    protected static final String NSIS_OPT_OUTPUT = "O";
    protected static final String NSIS_OPT_PAUSE = "PAUSE";
    protected static final String NSIS_OPT_NOCONFIG = "NOCONFIG";
    protected static final String NSIS_OPT_NOCD = "NOCD";
    protected static final String NSIS_OPT_DEFINE = "D";
    protected static final String NSIS_OPT_SCRIPTCMD = "X";
    protected File m_fScript;
    protected Integer m_iVerbosity;
    protected File m_fOut;
    protected Boolean m_bPause;
    protected Boolean m_bNoconfig;
    protected Boolean m_bNocd;
    protected char m_cPrefix = (char)(System.getProperty("os.name").startsWith("Windows") ? 47 : 45);
    protected List m_lDefines = new ArrayList();
    protected List m_lScriptcmds = new ArrayList();

    public void execute() {
        if (this.m_fScript == null) {
            throw new BuildException("Attribute 'script' is required", this.getLocation());
        }
        ArrayList<String> lArgs = new ArrayList<String>();
        if (this.m_iVerbosity != null) {
            lArgs.add(String.valueOf(this.m_cPrefix) + NSIS_OPT_VERBOSITY + this.m_iVerbosity);
        }
        if (this.m_fOut != null) {
            lArgs.add(String.valueOf(this.m_cPrefix) + NSIS_OPT_OUTPUT + this.m_fOut.getPath());
        }
        if (this.m_bPause != null) {
            lArgs.add(String.valueOf(this.m_cPrefix) + NSIS_OPT_PAUSE);
        }
        if (this.m_bNoconfig != null && this.m_bNoconfig.booleanValue()) {
            lArgs.add(String.valueOf(this.m_cPrefix) + NSIS_OPT_NOCONFIG);
        }
        if (this.m_bNocd != null && this.m_bNocd.booleanValue()) {
            lArgs.add(String.valueOf(this.m_cPrefix) + NSIS_OPT_NOCD);
        }
        int iCnt = 0;
        while (iCnt < this.m_lDefines.size()) {
            Define define = (Define)this.m_lDefines.get(iCnt);
            String sName = define.getName();
            if (sName == null) {
                throw new BuildException("Attribute 'name' is required", this.getLocation());
            }
            String sValue = define.getValue();
            if (sValue == null) {
                throw new BuildException("Attribute 'value' is required", this.getLocation());
            }
            lArgs.add(String.valueOf(this.m_cPrefix) + NSIS_OPT_DEFINE + sName + "=" + sValue);
            ++iCnt;
        }
        iCnt = 0;
        while (iCnt < this.m_lScriptcmds.size()) {
            Scriptcmd scriptcmd = (Scriptcmd)this.m_lScriptcmds.get(iCnt);
            String sCmd = scriptcmd.getCmd();
            if (sCmd == null) {
                throw new BuildException("Attribute 'cmd' is required", this.getLocation());
            }
            lArgs.add(String.valueOf(this.m_cPrefix) + NSIS_OPT_SCRIPTCMD + sCmd);
            ++iCnt;
        }
        lArgs.add(this.m_fScript.getPath());
        Commandline cmd = new Commandline();
        cmd.setExecutable(NSIS_CMD_LINE);
        cmd.addArguments(lArgs.toArray(new String[lArgs.size()]));
        Execute exe = new Execute((ExecuteStreamHandler)new LogStreamHandler((org.apache.tools.ant.Task)this, 2, 1));
        exe.setAntRun(this.getProject());
        exe.setWorkingDirectory(this.getProject().getBaseDir());
        exe.setCommandline(cmd.getCommandline());
        try {
            int iError = exe.execute();
            if (iError != 0) {
                throw new BuildException("Command failed, error code " + iError + ": '" + cmd + "'", this.getLocation());
            }
            this.log("Successfully compiled script " + this.m_fScript, 2);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new BuildException("Command failed: '" + cmd + "'", (Throwable)ex, this.getLocation());
        }
    }

    public void addDefine(Define element) {
        this.m_lDefines.add(element);
    }

    public void addScriptcmd(Scriptcmd element) {
        this.m_lScriptcmds.add(element);
    }

    public void setScript(File fScript) {
        this.m_fScript = fScript;
    }

    public void setVerbosity(Verbosity verbosity) {
        try {
            this.m_iVerbosity = new Integer(verbosity.getValue());
        }
        catch (NumberFormatException ex) {
            ex.printStackTrace();
        }
    }

    public void setOut(File fOut) {
        this.m_fOut = fOut;
    }

    public void setPause(Boolean bPause) {
        this.m_bPause = bPause;
    }

    public void setNoconfig(Boolean bNoconfig) {
        this.m_bNoconfig = bNoconfig;
    }

    public void setNocd(Boolean bNocd) {
        this.m_bNocd = bNocd;
    }

    public void setPrefix(char cPrefix) {
        this.m_cPrefix = cPrefix;
    }
}

