/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.querybuilder;

import java.awt.Color;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import nickyb.sqleonardo.common.util.Text;
import nickyb.sqleonardo.querybuilder.syntax._ReservedWords;

public class QueryStyledDocument
extends DefaultStyledDocument
implements _ReservedWords {
    protected static final String DELIMITER_LINE_END = "\n";
    protected MutableAttributeSet defaultAttributSet;
    protected MutableAttributeSet keywordAttributSet;

    public QueryStyledDocument() {
        this.putProperty("__EndOfLine__", DELIMITER_LINE_END);
        this.defaultAttributSet = new SimpleAttributeSet();
        StyleConstants.setForeground(this.defaultAttributSet, Color.black);
        this.keywordAttributSet = new SimpleAttributeSet();
        StyleConstants.setForeground(this.keywordAttributSet, Color.blue);
        StyleConstants.setBold(this.keywordAttributSet, true);
    }

    public void insertString(int offset, String str) throws BadLocationException {
        this.insertString(offset, str, this.defaultAttributSet);
    }

    public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
        super.insertString(offset, str, a);
        this.onChanged(offset, str.length());
    }

    public void remove(int offset, int length) throws BadLocationException {
        super.remove(offset, length);
        this.onChanged(offset, 0);
    }

    protected void onChanged(int offset, int length) throws BadLocationException {
        int contentLength = this.getLength();
        String content = this.getText(0, contentLength);
        if (Text.isEmpty(content)) {
            return;
        }
        Element root = this.getDefaultRootElement();
        int startLine = root.getElementIndex(offset);
        int endLine = root.getElementIndex(offset + length);
        for (int i = startLine; i <= endLine; ++i) {
            int startOffset = root.getElement(i).getStartOffset();
            int endOffset = root.getElement(i).getEndOffset();
            if (endOffset > contentLength) {
                endOffset = contentLength;
            }
            if (content.substring(startOffset, endOffset).endsWith(DELIMITER_LINE_END)) {
                this.doSyntaxHighlight(content, startOffset, endOffset - 1);
                continue;
            }
            this.doSyntaxHighlight(content, startOffset, endOffset);
        }
    }

    protected void doSyntaxHighlight(String content, int startOffset, int endOffset) throws BadLocationException {
        this.setCharacterAttributes(startOffset, endOffset - startOffset, this.defaultAttributSet, true);
        if (startOffset > endOffset) {
            return;
        }
        this.checkKeywords(content, startOffset, endOffset);
    }

    protected void checkKeywords(String content, int startOffset, int endOffset) {
        String line = content.substring(startOffset, endOffset);
        this.checkKeyword(line, "ALL", startOffset);
        this.checkKeyword(line, "DISTINCT", startOffset);
        this.checkKeyword(line, "SELECT", startOffset);
        this.checkKeyword(line, "FROM", startOffset);
        this.checkKeyword(line, "WHERE", startOffset);
        this.checkKeyword(line, "GROUP BY", startOffset);
        this.checkKeyword(line, "HAVING", startOffset);
        this.checkKeyword(line, "UNION", startOffset);
        this.checkKeyword(line, "ORDER BY", startOffset);
        this.checkKeyword(line, "BETWEEN", startOffset);
        this.checkKeyword(line, "AS", startOffset);
        this.checkKeyword(line, "AND", startOffset);
        this.checkKeyword(line, "OR", startOffset);
        this.checkKeyword(line, "ON", startOffset);
        this.checkKeyword(line, "INNER JOIN", startOffset);
        this.checkKeyword(line, "LEFT OUTER JOIN", startOffset);
        this.checkKeyword(line, "RIGHT OUTER JOIN", startOffset);
        this.checkKeyword(line, "FULL OUTER JOIN", startOffset);
    }

    protected void checkKeyword(String line, String keyword, int offsetgap) {
        String upper = line.toUpperCase();
        int i = upper.indexOf(keyword);
        while (i != -1) {
            boolean bKeyword = true;
            if (i > 0) {
                bKeyword = this.isKeySeparator(line.charAt(i - 1));
            }
            if (bKeyword && i + keyword.length() < line.length()) {
                bKeyword = this.isKeySeparator(line.charAt(i + keyword.length()));
            }
            if (bKeyword) {
                this.setCharacterAttributes(offsetgap + i, keyword.length(), this.keywordAttributSet, false);
            }
            ++i;
            i = upper.indexOf(keyword, i);
        }
    }

    private boolean isKeySeparator(char c) {
        return c == ' ' || c == '\t' || c == '(' || c == ')';
    }
}

