/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.mongodb.connection;

import com.jaspersoft.mongodb.connection.MongoDbConnection;
import net.sf.jasperreports.engine.JRException;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.log4j.Logger;

public class MongoDbConnectionFactory
implements PoolableObjectFactory<MongoDbConnection> {
    private final Logger logger = Logger.getLogger(MongoDbConnectionFactory.class);
    private String mongoURI;
    private String username;
    private String password;

    public void activateObject(MongoDbConnection connection) throws Exception {
    }

    public void destroyObject(MongoDbConnection connection) throws Exception {
        this.logger.info((Object)"Factory destroy object");
        if (connection != null) {
            connection.close();
        }
    }

    public MongoDbConnection makeObject() throws Exception {
        this.logger.info((Object)"Factory make object");
        return new MongoDbConnection(this.mongoURI, this.username, this.password);
    }

    public void passivateObject(MongoDbConnection connection) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Passivate is not implemented");
        }
    }

    public boolean validateObject(MongoDbConnection connection) {
        this.logger.info((Object)"Factory validate object");
        if (connection != null) {
            try {
                return this.mongoURI.equals(connection.getMongoURI()) && this.username.equals(connection.getUsername()) && this.password.equals(connection.getPassword()) && connection.test().contains("success");
            }
            catch (JRException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public void setMongoURI(String mongoURI) {
        this.mongoURI = mongoURI;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

