/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRGenericElement;
import net.sf.jasperreports.engine.JRGenericElementParameter;
import net.sf.jasperreports.engine.JRGenericElementType;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.base.JRBaseElement;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;

public class JRBaseGenericElement
extends JRBaseElement
implements JRGenericElement {
    private static final long serialVersionUID = 10200L;
    private JRGenericElementType genericType;
    private List<JRGenericElementParameter> parameters;
    private EvaluationTimeEnum evaluationTimeValue = EvaluationTimeEnum.NOW;
    private String evaluationGroupName;
    private int PSEUDO_SERIAL_VERSION_UID = 40103;
    private byte evaluationTime;

    public JRBaseGenericElement(JRGenericElement element, JRBaseObjectFactory factory) {
        super(element, factory);
        this.genericType = element.getGenericType();
        this.evaluationTimeValue = element.getEvaluationTimeValue();
        this.evaluationGroupName = element.getEvaluationGroupName();
        JRGenericElementParameter[] elementParameters = element.getParameters();
        this.parameters = new ArrayList<JRGenericElementParameter>(elementParameters.length);
        for (int i = 0; i < elementParameters.length; ++i) {
            JRGenericElementParameter elementParameter = elementParameters[i];
            JRGenericElementParameter parameter = factory.getGenericElementParameter(elementParameter);
            this.parameters.add(parameter);
        }
    }

    public JRGenericElementType getGenericType() {
        return this.genericType;
    }

    public JRGenericElementParameter[] getParameters() {
        return this.parameters.toArray(new JRGenericElementParameter[this.parameters.size()]);
    }

    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    public void visit(JRVisitor visitor) {
        visitor.visitGenericElement(this);
    }

    public String getEvaluationGroupName() {
        return this.evaluationGroupName;
    }

    public EvaluationTimeEnum getEvaluationTimeValue() {
        return this.evaluationTimeValue;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.PSEUDO_SERIAL_VERSION_UID < 30702) {
            this.evaluationTimeValue = EvaluationTimeEnum.getByValue(this.evaluationTime);
        }
    }
}

