/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.typeinfo;

import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.UnionObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.UnionTypeInfo;

public final class TypeInfoUtils {
    static HashMap<TypeInfo, ObjectInspector> cachedStandardObjectInspector = new HashMap();
    static HashMap<TypeInfo, ObjectInspector> cachedStandardJavaObjectInspector = new HashMap();

    private TypeInfoUtils() {
    }

    private static TypeInfo getExtendedTypeInfoFromJavaType(Type t, Method m) {
        if (t == Object.class) {
            return TypeInfoFactory.unknownTypeInfo;
        }
        if (t instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)t;
            if (List.class == (Class)pt.getRawType() || ArrayList.class == (Class)pt.getRawType()) {
                return TypeInfoFactory.getListTypeInfo(TypeInfoUtils.getExtendedTypeInfoFromJavaType(pt.getActualTypeArguments()[0], m));
            }
            if (Map.class == (Class)pt.getRawType() || HashMap.class == (Class)pt.getRawType()) {
                return TypeInfoFactory.getMapTypeInfo(TypeInfoUtils.getExtendedTypeInfoFromJavaType(pt.getActualTypeArguments()[0], m), TypeInfoUtils.getExtendedTypeInfoFromJavaType(pt.getActualTypeArguments()[1], m));
            }
            t = pt.getRawType();
        }
        if (!(t instanceof Class)) {
            throw new RuntimeException("Hive does not understand type " + t + " from " + m);
        }
        Class c = (Class)t;
        if (PrimitiveObjectInspectorUtils.isPrimitiveJavaType(c)) {
            return TypeInfoUtils.getTypeInfoFromObjectInspector(PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector(PrimitiveObjectInspectorUtils.getTypeEntryFromPrimitiveJavaType(c).primitiveCategory));
        }
        if (PrimitiveObjectInspectorUtils.isPrimitiveJavaClass(c)) {
            return TypeInfoUtils.getTypeInfoFromObjectInspector(PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector(PrimitiveObjectInspectorUtils.getTypeEntryFromPrimitiveJavaClass(c).primitiveCategory));
        }
        if (PrimitiveObjectInspectorUtils.isPrimitiveWritableClass(c)) {
            return TypeInfoUtils.getTypeInfoFromObjectInspector(PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector(PrimitiveObjectInspectorUtils.getTypeEntryFromPrimitiveWritableClass(c).primitiveCategory));
        }
        Field[] fields = ObjectInspectorUtils.getDeclaredNonStaticFields(c);
        ArrayList<String> fieldNames = new ArrayList<String>(fields.length);
        ArrayList<TypeInfo> fieldTypeInfos = new ArrayList<TypeInfo>(fields.length);
        for (Field field : fields) {
            fieldNames.add(field.getName());
            fieldTypeInfos.add(TypeInfoUtils.getExtendedTypeInfoFromJavaType(field.getGenericType(), m));
        }
        return TypeInfoFactory.getStructTypeInfo(fieldNames, fieldTypeInfos);
    }

    public static Type getArrayElementType(Type t) {
        if (t instanceof Class && ((Class)t).isArray()) {
            Class arrayClass = (Class)t;
            return arrayClass.getComponentType();
        }
        if (t instanceof GenericArrayType) {
            GenericArrayType arrayType = (GenericArrayType)t;
            return arrayType.getGenericComponentType();
        }
        return null;
    }

    public static List<TypeInfo> getParameterTypeInfos(Method m, int size) {
        Type[] methodParameterTypes = m.getGenericParameterTypes();
        Type lastParaElementType = TypeInfoUtils.getArrayElementType(methodParameterTypes.length == 0 ? null : methodParameterTypes[methodParameterTypes.length - 1]);
        boolean isVariableLengthArgument = lastParaElementType != null;
        ArrayList<TypeInfo> typeInfos = null;
        if (!isVariableLengthArgument) {
            if (size != methodParameterTypes.length) {
                return null;
            }
            typeInfos = new ArrayList<TypeInfo>(methodParameterTypes.length);
            for (Type methodParameterType : methodParameterTypes) {
                typeInfos.add(TypeInfoUtils.getExtendedTypeInfoFromJavaType(methodParameterType, m));
            }
        } else {
            int i;
            if (size < methodParameterTypes.length - 1) {
                return null;
            }
            typeInfos = new ArrayList(size);
            for (i = 0; i < methodParameterTypes.length - 1; ++i) {
                typeInfos.add(TypeInfoUtils.getExtendedTypeInfoFromJavaType(methodParameterTypes[i], m));
            }
            for (i = methodParameterTypes.length - 1; i < size; ++i) {
                typeInfos.add(TypeInfoUtils.getExtendedTypeInfoFromJavaType(lastParaElementType, m));
            }
        }
        return typeInfos;
    }

    public static ObjectInspector getStandardWritableObjectInspectorFromTypeInfo(TypeInfo typeInfo) {
        ObjectInspector result = cachedStandardObjectInspector.get(typeInfo);
        if (result == null) {
            switch (typeInfo.getCategory()) {
                case PRIMITIVE: {
                    result = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector(((PrimitiveTypeInfo)typeInfo).getPrimitiveCategory());
                    break;
                }
                case LIST: {
                    ObjectInspector elementObjectInspector = TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo(((ListTypeInfo)typeInfo).getListElementTypeInfo());
                    result = ObjectInspectorFactory.getStandardListObjectInspector(elementObjectInspector);
                    break;
                }
                case MAP: {
                    MapTypeInfo mapTypeInfo = (MapTypeInfo)typeInfo;
                    ObjectInspector keyObjectInspector = TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo(mapTypeInfo.getMapKeyTypeInfo());
                    ObjectInspector valueObjectInspector = TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo(mapTypeInfo.getMapValueTypeInfo());
                    result = ObjectInspectorFactory.getStandardMapObjectInspector(keyObjectInspector, valueObjectInspector);
                    break;
                }
                case STRUCT: {
                    StructTypeInfo structTypeInfo = (StructTypeInfo)typeInfo;
                    ArrayList<String> fieldNames = structTypeInfo.getAllStructFieldNames();
                    ArrayList<TypeInfo> fieldTypeInfos = structTypeInfo.getAllStructFieldTypeInfos();
                    ArrayList<ObjectInspector> fieldObjectInspectors = new ArrayList<ObjectInspector>(fieldTypeInfos.size());
                    for (int i = 0; i < fieldTypeInfos.size(); ++i) {
                        fieldObjectInspectors.add(TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo((TypeInfo)fieldTypeInfos.get(i)));
                    }
                    result = ObjectInspectorFactory.getStandardStructObjectInspector(fieldNames, fieldObjectInspectors);
                    break;
                }
                case UNION: {
                    UnionTypeInfo unionTypeInfo = (UnionTypeInfo)typeInfo;
                    List<TypeInfo> objectTypeInfos = unionTypeInfo.getAllUnionObjectTypeInfos();
                    ArrayList<ObjectInspector> fieldObjectInspectors = new ArrayList<ObjectInspector>(objectTypeInfos.size());
                    for (int i = 0; i < objectTypeInfos.size(); ++i) {
                        fieldObjectInspectors.add(TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo(objectTypeInfos.get(i)));
                    }
                    result = ObjectInspectorFactory.getStandardUnionObjectInspector(fieldObjectInspectors);
                    break;
                }
                default: {
                    result = null;
                }
            }
            cachedStandardObjectInspector.put(typeInfo, result);
        }
        return result;
    }

    public static ObjectInspector getStandardJavaObjectInspectorFromTypeInfo(TypeInfo typeInfo) {
        ObjectInspector result = cachedStandardJavaObjectInspector.get(typeInfo);
        if (result == null) {
            switch (typeInfo.getCategory()) {
                case PRIMITIVE: {
                    result = PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector(PrimitiveObjectInspectorUtils.getTypeEntryFromTypeName((String)typeInfo.getTypeName()).primitiveCategory);
                    break;
                }
                case LIST: {
                    ObjectInspector elementObjectInspector = TypeInfoUtils.getStandardJavaObjectInspectorFromTypeInfo(((ListTypeInfo)typeInfo).getListElementTypeInfo());
                    result = ObjectInspectorFactory.getStandardListObjectInspector(elementObjectInspector);
                    break;
                }
                case MAP: {
                    MapTypeInfo mapTypeInfo = (MapTypeInfo)typeInfo;
                    ObjectInspector keyObjectInspector = TypeInfoUtils.getStandardJavaObjectInspectorFromTypeInfo(mapTypeInfo.getMapKeyTypeInfo());
                    ObjectInspector valueObjectInspector = TypeInfoUtils.getStandardJavaObjectInspectorFromTypeInfo(mapTypeInfo.getMapValueTypeInfo());
                    result = ObjectInspectorFactory.getStandardMapObjectInspector(keyObjectInspector, valueObjectInspector);
                    break;
                }
                case STRUCT: {
                    StructTypeInfo strucTypeInfo = (StructTypeInfo)typeInfo;
                    ArrayList<String> fieldNames = strucTypeInfo.getAllStructFieldNames();
                    ArrayList<TypeInfo> fieldTypeInfos = strucTypeInfo.getAllStructFieldTypeInfos();
                    ArrayList<ObjectInspector> fieldObjectInspectors = new ArrayList<ObjectInspector>(fieldTypeInfos.size());
                    for (int i = 0; i < fieldTypeInfos.size(); ++i) {
                        fieldObjectInspectors.add(TypeInfoUtils.getStandardJavaObjectInspectorFromTypeInfo((TypeInfo)fieldTypeInfos.get(i)));
                    }
                    result = ObjectInspectorFactory.getStandardStructObjectInspector(fieldNames, fieldObjectInspectors);
                    break;
                }
                case UNION: {
                    UnionTypeInfo unionTypeInfo = (UnionTypeInfo)typeInfo;
                    List<TypeInfo> objectTypeInfos = unionTypeInfo.getAllUnionObjectTypeInfos();
                    ArrayList<ObjectInspector> fieldObjectInspectors = new ArrayList<ObjectInspector>(objectTypeInfos.size());
                    for (int i = 0; i < objectTypeInfos.size(); ++i) {
                        fieldObjectInspectors.add(TypeInfoUtils.getStandardJavaObjectInspectorFromTypeInfo(objectTypeInfos.get(i)));
                    }
                    result = ObjectInspectorFactory.getStandardUnionObjectInspector(fieldObjectInspectors);
                    break;
                }
                default: {
                    result = null;
                }
            }
            cachedStandardJavaObjectInspector.put(typeInfo, result);
        }
        return result;
    }

    public static TypeInfo getTypeInfoFromObjectInspector(ObjectInspector oi) {
        if (oi == null) {
            return null;
        }
        TypeInfo result = null;
        switch (oi.getCategory()) {
            case PRIMITIVE: {
                PrimitiveObjectInspector poi = (PrimitiveObjectInspector)oi;
                result = TypeInfoFactory.getPrimitiveTypeInfo(poi.getTypeName());
                break;
            }
            case LIST: {
                ListObjectInspector loi = (ListObjectInspector)oi;
                result = TypeInfoFactory.getListTypeInfo(TypeInfoUtils.getTypeInfoFromObjectInspector(loi.getListElementObjectInspector()));
                break;
            }
            case MAP: {
                MapObjectInspector moi = (MapObjectInspector)oi;
                result = TypeInfoFactory.getMapTypeInfo(TypeInfoUtils.getTypeInfoFromObjectInspector(moi.getMapKeyObjectInspector()), TypeInfoUtils.getTypeInfoFromObjectInspector(moi.getMapValueObjectInspector()));
                break;
            }
            case STRUCT: {
                StructObjectInspector soi = (StructObjectInspector)oi;
                List<? extends StructField> fields = soi.getAllStructFieldRefs();
                ArrayList<String> fieldNames = new ArrayList<String>(fields.size());
                ArrayList<TypeInfo> fieldTypeInfos = new ArrayList<TypeInfo>(fields.size());
                for (StructField structField : fields) {
                    fieldNames.add(structField.getFieldName());
                    fieldTypeInfos.add(TypeInfoUtils.getTypeInfoFromObjectInspector(structField.getFieldObjectInspector()));
                }
                result = TypeInfoFactory.getStructTypeInfo(fieldNames, fieldTypeInfos);
                break;
            }
            case UNION: {
                UnionObjectInspector uoi = (UnionObjectInspector)oi;
                ArrayList<TypeInfo> objectTypeInfos = new ArrayList<TypeInfo>();
                for (ObjectInspector eoi : uoi.getObjectInspectors()) {
                    objectTypeInfos.add(TypeInfoUtils.getTypeInfoFromObjectInspector(eoi));
                }
                result = TypeInfoFactory.getUnionTypeInfo(objectTypeInfos);
                break;
            }
            default: {
                throw new RuntimeException("Unknown ObjectInspector category!");
            }
        }
        return result;
    }

    public static ArrayList<TypeInfo> getTypeInfosFromTypeString(String typeString) {
        TypeInfoParser parser = new TypeInfoParser(typeString);
        return parser.parseTypeInfos();
    }

    public static TypeInfo getTypeInfoFromTypeString(String typeString) {
        TypeInfoParser parser = new TypeInfoParser(typeString);
        return parser.parseTypeInfos().get(0);
    }

    private static class TypeInfoParser {
        private final String typeInfoString;
        private final ArrayList<Token> typeInfoTokens;
        private ArrayList<TypeInfo> typeInfos;
        private int iToken;

        private static boolean isTypeChar(char c) {
            return Character.isLetterOrDigit(c) || c == '_' || c == '.';
        }

        private static ArrayList<Token> tokenize(String typeInfoString) {
            ArrayList<Token> tokens = new ArrayList<Token>(0);
            int begin = 0;
            for (int end = 1; end <= typeInfoString.length(); ++end) {
                if (end != typeInfoString.length() && TypeInfoParser.isTypeChar(typeInfoString.charAt(end - 1)) && TypeInfoParser.isTypeChar(typeInfoString.charAt(end))) continue;
                Token t = new Token();
                t.position = begin;
                t.text = typeInfoString.substring(begin, end);
                t.isType = TypeInfoParser.isTypeChar(typeInfoString.charAt(begin));
                tokens.add(t);
                begin = end;
            }
            return tokens;
        }

        public TypeInfoParser(String typeInfoString) {
            this.typeInfoString = typeInfoString;
            this.typeInfoTokens = TypeInfoParser.tokenize(typeInfoString);
        }

        public ArrayList<TypeInfo> parseTypeInfos() {
            this.typeInfos = new ArrayList();
            this.iToken = 0;
            while (this.iToken < this.typeInfoTokens.size()) {
                this.typeInfos.add(this.parseType());
                if (this.iToken >= this.typeInfoTokens.size()) continue;
                Token separator = this.typeInfoTokens.get(this.iToken);
                if (",".equals(separator.text) || ";".equals(separator.text) || ":".equals(separator.text)) {
                    ++this.iToken;
                    continue;
                }
                throw new IllegalArgumentException("Error: ',', ':', or ';' expected at position " + separator.position + " from '" + this.typeInfoString + "' " + this.typeInfoTokens);
            }
            return this.typeInfos;
        }

        private Token expect(String item) {
            return this.expect(item, null);
        }

        private Token expect(String item, String alternative) {
            if (this.iToken >= this.typeInfoTokens.size()) {
                throw new IllegalArgumentException("Error: " + item + " expected at the end of '" + this.typeInfoString + "'");
            }
            Token t = this.typeInfoTokens.get(this.iToken);
            if (item.equals("type") ? !"array".equals(t.text) && !"map".equals(t.text) && !"struct".equals(t.text) && !"uniontype".equals(t.text) && null == PrimitiveObjectInspectorUtils.getTypeEntryFromTypeName(t.text) && !t.text.equals(alternative) : (item.equals("name") ? !t.isType && !t.text.equals(alternative) : !item.equals(t.text) && !t.text.equals(alternative))) {
                throw new IllegalArgumentException("Error: " + item + " expected at the position " + t.position + " of '" + this.typeInfoString + "' but '" + t.text + "' is found.");
            }
            ++this.iToken;
            return t;
        }

        private TypeInfo parseType() {
            Token t = this.expect("type");
            PrimitiveObjectInspectorUtils.PrimitiveTypeEntry primitiveType = PrimitiveObjectInspectorUtils.getTypeEntryFromTypeName(t.text);
            if (primitiveType != null && !primitiveType.primitiveCategory.equals((Object)PrimitiveObjectInspector.PrimitiveCategory.UNKNOWN)) {
                return TypeInfoFactory.getPrimitiveTypeInfo(primitiveType.typeName);
            }
            if ("array".equals(t.text)) {
                this.expect("<");
                TypeInfo listElementType = this.parseType();
                this.expect(">");
                return TypeInfoFactory.getListTypeInfo(listElementType);
            }
            if ("map".equals(t.text)) {
                this.expect("<");
                TypeInfo mapKeyType = this.parseType();
                this.expect(",");
                TypeInfo mapValueType = this.parseType();
                this.expect(">");
                return TypeInfoFactory.getMapTypeInfo(mapKeyType, mapValueType);
            }
            if ("struct".equals(t.text)) {
                ArrayList<String> fieldNames = new ArrayList<String>();
                ArrayList<TypeInfo> fieldTypeInfos = new ArrayList<TypeInfo>();
                boolean first = true;
                while (true) {
                    if (first) {
                        this.expect("<");
                        first = false;
                    } else {
                        Token separator = this.expect(">", ",");
                        if (separator.text.equals(">")) break;
                    }
                    Token name = this.expect("name");
                    fieldNames.add(name.text);
                    this.expect(":");
                    fieldTypeInfos.add(this.parseType());
                }
                return TypeInfoFactory.getStructTypeInfo(fieldNames, fieldTypeInfos);
            }
            if ("uniontype".equals(t.text)) {
                ArrayList<TypeInfo> objectTypeInfos = new ArrayList<TypeInfo>();
                boolean first = true;
                while (true) {
                    if (first) {
                        this.expect("<");
                        first = false;
                    } else {
                        Token separator = this.expect(">", ",");
                        if (separator.text.equals(">")) break;
                    }
                    objectTypeInfos.add(this.parseType());
                }
                return TypeInfoFactory.getUnionTypeInfo(objectTypeInfos);
            }
            throw new RuntimeException("Internal error parsing position " + t.position + " of '" + this.typeInfoString + "'");
        }

        private static class Token {
            public int position;
            public String text;
            public boolean isType;

            private Token() {
            }

            public String toString() {
                return "" + this.position + ":" + this.text;
            }
        }
    }
}

