/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j.driver.xmla.proxy;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import java.util.concurrent.Future;
import org.olap4j.OlapException;
import org.olap4j.driver.xmla.XmlaHelper;
import org.olap4j.driver.xmla.XmlaOlap4jDriver;
import org.olap4j.driver.xmla.cache.XmlaOlap4jCache;
import org.olap4j.driver.xmla.proxy.XmlaOlap4jCachedProxy;
import org.olap4j.driver.xmla.proxy.XmlaOlap4jCookieManager;
import org.olap4j.driver.xmla.proxy.XmlaOlap4jProxyException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class XmlaOlap4jAbstractHttpProxy
implements XmlaOlap4jCachedProxy {
    private final XmlaHelper helper = new XmlaHelper();
    private XmlaOlap4jCache cache = null;
    private String cacheId;
    private XmlaOlap4jCookieManager cookieManager = null;

    protected XmlaOlap4jAbstractHttpProxy() {
    }

    public abstract byte[] getResponse(URL var1, String var2) throws XmlaOlap4jProxyException;

    public abstract Future<byte[]> getResponseViaSubmit(URL var1, String var2);

    protected void useCookies(URLConnection urlConn) {
        this.initCookieManager();
        this.cookieManager.setCookies(urlConn);
    }

    protected void saveCookies(URLConnection urlConn) {
        this.initCookieManager();
        this.cookieManager.storeCookies(urlConn);
    }

    @Override
    public void setCache(Map<String, String> config, Map<String, String> properties) throws OlapException {
        try {
            Class<?> clazz = Class.forName(config.get(XmlaOlap4jDriver.Property.Cache.name()));
            this.cache = (XmlaOlap4jCache)clazz.newInstance();
            this.cacheId = this.cache.setParameters(config, properties);
        }
        catch (ClassNotFoundException e) {
            throw this.helper.createException("The specified cache class name could not be found : " + config.get(XmlaOlap4jDriver.Property.Cache.name()), e);
        }
        catch (InstantiationException e) {
            throw this.helper.createException("The specified cache class name could not be instanciated : " + config.get(XmlaOlap4jDriver.Property.Cache.name()), e);
        }
        catch (IllegalAccessException e) {
            throw this.helper.createException("An error was encountered while instanciating the cache : " + config.get(XmlaOlap4jDriver.Property.Cache.name()), e);
        }
        catch (IllegalArgumentException e) {
            throw this.helper.createException("An error was encountered while instanciating the cache : " + config.get(XmlaOlap4jDriver.Property.Cache.name()), e);
        }
        catch (SecurityException e) {
            throw this.helper.createException("An error was encountered while instanciating the cache : " + config.get(XmlaOlap4jDriver.Property.Cache.name()), e);
        }
    }

    @Override
    public byte[] get(URL url, String request) throws XmlaOlap4jProxyException {
        byte[] response = null;
        try {
            response = this.getFromCache(url, request.getBytes(this.getEncodingCharsetName()));
            if (response != null) {
                return response;
            }
        }
        catch (IOException e) {
            throw new XmlaOlap4jProxyException("An exception was encountered while browsing the proxy cache.", e);
        }
        response = this.getResponse(url, request);
        try {
            this.addToCache(url, request.getBytes(this.getEncodingCharsetName()), response);
            return response;
        }
        catch (IOException e) {
            throw new XmlaOlap4jProxyException("An exception was encountered while saving a response in the proxy cache.", e);
        }
    }

    private byte[] getFromCache(URL url, byte[] request) {
        return this.cache != null ? this.cache.get(this.cacheId, url, request) : null;
    }

    private void addToCache(URL url, byte[] request, byte[] response) {
        if (this.cache != null) {
            this.cache.put(this.cacheId, url, request, response);
        }
    }

    @Override
    public Future<byte[]> submit(URL url, String request) {
        return this.getResponseViaSubmit(url, request);
    }

    private void initCookieManager() {
        if (this.cookieManager == null) {
            this.cookieManager = new XmlaOlap4jCookieManager();
        }
    }
}

