/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * TableStyleDesigner.java
 *
 * Created on 7-apr-2010, 10.22.09
 */

package com.jaspersoft.ireport.components.table.style;

import com.jaspersoft.ireport.designer.sheet.Tag;
import com.jaspersoft.ireport.designer.utils.ColorSchemaGenerator;
import com.jaspersoft.ireport.designer.utils.Misc;
import java.awt.BorderLayout;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.design.JRDesignConditionalStyle;
import net.sf.jasperreports.engine.design.JRDesignStyle;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.type.LineStyleEnum;
import net.sf.jasperreports.engine.type.ModeEnum;

/**
 *
 * @author gtoffoli
 */
public class TableStyleDesigner extends javax.swing.JPanel {

    TableStylePreview previewPanel = null;
    /** Creates new form TableStyleDesigner */
    public TableStyleDesigner() {
        initComponents();

        jComboBoxColors.setRenderer(new ComboBoxColorRenderer());
        
        List<String> colors = ColorSchemaGenerator.getColors();
        for (int i=0; i<colors.size(); ++i)
        {
            jComboBoxColors.addItem(colors.get(i));
        }

        List<Tag> variants = ColorSchemaGenerator.getVariants();
        for (int i=0; i<variants.size(); ++i)
        {
            jComboBoxVariations.addItem(variants.get(i));
        }

        previewPanel = new TableStylePreview();
        jPanelPreview.add(previewPanel, BorderLayout.CENTER);
        updatePreview();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        buttonGroup1 = new javax.swing.ButtonGroup();
        jPanel1 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        jComboBoxColors = new javax.swing.JComboBox();
        jComboBoxVariations = new javax.swing.JComboBox();
        jLabel2 = new javax.swing.JLabel();
        jCheckBox1 = new javax.swing.JCheckBox();
        jPanel2 = new javax.swing.JPanel();
        colorSelectorPanel1 = new com.jaspersoft.ireport.designer.sheet.editors.box.ColorSelectorPanel();
        jLabel3 = new javax.swing.JLabel();
        jToggleButton1 = new javax.swing.JToggleButton();
        jToggleButton2 = new javax.swing.JToggleButton();
        jLabel4 = new javax.swing.JLabel();
        jToggleButton3 = new javax.swing.JToggleButton();
        jPanelPreview = new javax.swing.JPanel();

        jPanel1.setBorder(javax.swing.BorderFactory.createTitledBorder(org.openide.util.NbBundle.getMessage(TableStyleDesigner.class, "TableStyleDesigner.jPanel1.border.title"))); // NOI18N

        jLabel1.setText(org.openide.util.NbBundle.getMessage(TableStyleDesigner.class, "TableStyleDesigner.jLabel1.text")); // NOI18N

        jComboBoxColors.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxColorsActionPerformed(evt);
            }
        });

        jComboBoxVariations.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxVariationsActionPerformed(evt);
            }
        });

        jLabel2.setText(org.openide.util.NbBundle.getMessage(TableStyleDesigner.class, "TableStyleDesigner.jLabel2.text")); // NOI18N

        jCheckBox1.setText(org.openide.util.NbBundle.getMessage(TableStyleDesigner.class, "TableStyleDesigner.jCheckBox1.text")); // NOI18N
        jCheckBox1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBox1ActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout jPanel1Layout = new org.jdesktop.layout.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jCheckBox1)
                    .add(jPanel1Layout.createSequentialGroup()
                        .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(jLabel1)
                            .add(jLabel2))
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                        .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(jComboBoxVariations, 0, 199, Short.MAX_VALUE)
                            .add(jComboBoxColors, 0, 199, Short.MAX_VALUE))))
                .addContainerGap())
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel1)
                    .add(jComboBoxColors, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel2)
                    .add(jComboBoxVariations, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .add(18, 18, 18)
                .add(jCheckBox1)
                .addContainerGap(10, Short.MAX_VALUE))
        );

        jPanel2.setBorder(javax.swing.BorderFactory.createTitledBorder(org.openide.util.NbBundle.getMessage(TableStyleDesigner.class, "TableStyleDesigner.jPanel2.border.title"))); // NOI18N

        colorSelectorPanel1.setColor(new java.awt.Color(0, 0, 0));
        colorSelectorPanel1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                colorSelectorPanel1ActionPerformed(evt);
            }
        });

        jLabel3.setText(org.openide.util.NbBundle.getMessage(TableStyleDesigner.class, "TableStyleDesigner.jLabel3.text")); // NOI18N

        buttonGroup1.add(jToggleButton1);
        jToggleButton1.setIcon(new javax.swing.ImageIcon(getClass().getResource("/com/jaspersoft/ireport/components/table/style/full_borders.png"))); // NOI18N
        jToggleButton1.setSelected(true);
        jToggleButton1.setText(org.openide.util.NbBundle.getMessage(TableStyleDesigner.class, "TableStyleDesigner.jToggleButton1.text")); // NOI18N
        jToggleButton1.setMargin(new java.awt.Insets(2, 2, 2, 2));
        jToggleButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jToggleButton1ActionPerformed(evt);
            }
        });

        buttonGroup1.add(jToggleButton2);
        jToggleButton2.setIcon(new javax.swing.ImageIcon(getClass().getResource("/com/jaspersoft/ireport/components/table/style/horizontal_borders.png"))); // NOI18N
        jToggleButton2.setText(org.openide.util.NbBundle.getMessage(TableStyleDesigner.class, "TableStyleDesigner.jToggleButton2.text")); // NOI18N
        jToggleButton2.setMargin(new java.awt.Insets(2, 2, 2, 2));
        jToggleButton2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jToggleButton2ActionPerformed(evt);
            }
        });

        jLabel4.setText(org.openide.util.NbBundle.getMessage(TableStyleDesigner.class, "TableStyleDesigner.jLabel4.text")); // NOI18N

        buttonGroup1.add(jToggleButton3);
        jToggleButton3.setIcon(new javax.swing.ImageIcon(getClass().getResource("/com/jaspersoft/ireport/components/table/style/horizontal_borders2.png"))); // NOI18N
        jToggleButton3.setText(org.openide.util.NbBundle.getMessage(TableStyleDesigner.class, "TableStyleDesigner.jToggleButton3.text")); // NOI18N
        jToggleButton3.setMargin(new java.awt.Insets(2, 2, 2, 2));
        jToggleButton3.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jToggleButton3ActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout jPanel2Layout = new org.jdesktop.layout.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jLabel3)
                    .add(colorSelectorPanel1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 101, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .add(27, 27, 27)
                .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jPanel2Layout.createSequentialGroup()
                        .add(jToggleButton1)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(jToggleButton2)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(jToggleButton3))
                    .add(jLabel4))
                .addContainerGap(20, Short.MAX_VALUE))
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, jPanel2Layout.createSequentialGroup()
                .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel3)
                    .add(jLabel4))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jToggleButton3)
                    .add(colorSelectorPanel1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jToggleButton1)
                    .add(jToggleButton2))
                .add(30, 30, 30))
        );

        jPanelPreview.setBorder(javax.swing.BorderFactory.createTitledBorder(org.openide.util.NbBundle.getMessage(TableStyleDesigner.class, "TableStyleDesigner.jPanelPreview.border.title"))); // NOI18N
        jPanelPreview.setMinimumSize(new java.awt.Dimension(200, 100));
        jPanelPreview.setLayout(new java.awt.BorderLayout());

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(jPanel2, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .add(jPanel1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanelPreview, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 200, Short.MAX_VALUE)
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, jPanelPreview, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 235, Short.MAX_VALUE)
                    .add(layout.createSequentialGroup()
                        .add(jPanel1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                        .add(jPanel2, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 89, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents

    private void jComboBoxColorsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxColorsActionPerformed
        updatePreview();
    }//GEN-LAST:event_jComboBoxColorsActionPerformed

    private void jComboBoxVariationsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxVariationsActionPerformed
        updatePreview();
}//GEN-LAST:event_jComboBoxVariationsActionPerformed

    private void jToggleButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jToggleButton1ActionPerformed
        updatePreview();
    }//GEN-LAST:event_jToggleButton1ActionPerformed

    private void jToggleButton2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jToggleButton2ActionPerformed
        updatePreview();
    }//GEN-LAST:event_jToggleButton2ActionPerformed

    private void colorSelectorPanel1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_colorSelectorPanel1ActionPerformed
        updatePreview();
    }//GEN-LAST:event_colorSelectorPanel1ActionPerformed

    private void jCheckBox1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBox1ActionPerformed
       updatePreview();
    }//GEN-LAST:event_jCheckBox1ActionPerformed

    private void jToggleButton3ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jToggleButton3ActionPerformed
        updatePreview();
    }//GEN-LAST:event_jToggleButton3ActionPerformed


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup buttonGroup1;
    private com.jaspersoft.ireport.designer.sheet.editors.box.ColorSelectorPanel colorSelectorPanel1;
    private javax.swing.JCheckBox jCheckBox1;
    private javax.swing.JComboBox jComboBoxColors;
    private javax.swing.JComboBox jComboBoxVariations;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanelPreview;
    private javax.swing.JToggleButton jToggleButton1;
    private javax.swing.JToggleButton jToggleButton2;
    private javax.swing.JToggleButton jToggleButton3;
    // End of variables declaration//GEN-END:variables


    public void updatePreview()
    {
        if (previewPanel == null) return;
        String s = ""+jComboBoxColors.getSelectedItem();
        Color c = ColorSchemaGenerator.getColor(s);
        if (c != null)
        {
            previewPanel.setColor(c);
        }

        Tag var = (Tag)jComboBoxVariations.getSelectedItem();

        if (var != null)
        {
            previewPanel.setVariant((String)var.getValue());
        }

        previewPanel.setBorderType(  jToggleButton1.isSelected() ? 0 : (jToggleButton2.isSelected() ? 1 : 2) );
        previewPanel.setBorderColor( colorSelectorPanel1.getColor()  );

        previewPanel.setZebra(jCheckBox1.isSelected());
    }


    public List<JRDesignStyle> createStyles(String baseName)
    {
        List<JRDesignStyle> styles = new ArrayList<JRDesignStyle>();

        JRDesignStyle tableStyle=  new JRDesignStyle();
        tableStyle.setName(baseName);

        if (jToggleButton1.isSelected() || jToggleButton2.isSelected())
        {
            tableStyle.getLineBox().getPen().setLineColor( colorSelectorPanel1.getColor() );
            //tableStyle.getLineBox().getPen().setLineStyle(LineStyleEnum.SOLID);
            tableStyle.getLineBox().getPen().setLineWidth(1.0f);
        }
        else
        {
            tableStyle.getLineBox().getTopPen().setLineColor( colorSelectorPanel1.getColor() );
            //tableStyle.getLineBox().getTopPen().setLineStyle(LineStyleEnum.SOLID);
            tableStyle.getLineBox().getTopPen().setLineWidth(1.0f);

            tableStyle.getLineBox().getBottomPen().setLineColor( colorSelectorPanel1.getColor() );
            //tableStyle.getLineBox().getBottomPen().setLineStyle(LineStyleEnum.SOLID);
            tableStyle.getLineBox().getBottomPen().setLineWidth(1.0f);
        }

        styles.add(tableStyle);

        JRDesignStyle tableHeaderStyle=  new JRDesignStyle();
        tableHeaderStyle.setName(baseName + "_TH");

        if (jToggleButton1.isSelected())
        {
            tableHeaderStyle.getLineBox().getPen().setLineColor( colorSelectorPanel1.getColor() );
            tableHeaderStyle.getLineBox().getPen().setLineWidth(0.5f);
        }
        else
        {
            tableHeaderStyle.getLineBox().getBottomPen().setLineColor( colorSelectorPanel1.getColor() );
            tableHeaderStyle.getLineBox().getBottomPen().setLineWidth(0.5f);
            tableHeaderStyle.getLineBox().getTopPen().setLineColor( colorSelectorPanel1.getColor() );
            tableHeaderStyle.getLineBox().getTopPen().setLineWidth(0.5f);
        }

        tableHeaderStyle.setMode(ModeEnum.OPAQUE);
        tableHeaderStyle.setBackcolor(ColorSchemaGenerator.createColor(previewPanel.getColor(), 3, previewPanel.getVariant()));

        styles.add(tableHeaderStyle);

        JRDesignStyle columnHeaderStyle=  new JRDesignStyle();
        columnHeaderStyle.setName(baseName + "_CH");

        if (jToggleButton1.isSelected())
        {
            columnHeaderStyle.getLineBox().getPen().setLineColor( colorSelectorPanel1.getColor() );
            columnHeaderStyle.getLineBox().getPen().setLineWidth(0.5f);
        }
        else
        {
            columnHeaderStyle.getLineBox().getBottomPen().setLineColor( colorSelectorPanel1.getColor() );
            columnHeaderStyle.getLineBox().getBottomPen().setLineWidth(0.5f);
            columnHeaderStyle.getLineBox().getTopPen().setLineColor( colorSelectorPanel1.getColor() );
            columnHeaderStyle.getLineBox().getTopPen().setLineWidth(0.5f);
        }

        columnHeaderStyle.setMode(ModeEnum.OPAQUE);
        columnHeaderStyle.setBackcolor(ColorSchemaGenerator.createColor(previewPanel.getColor(), 2, previewPanel.getVariant()));


        styles.add(columnHeaderStyle);

        JRDesignStyle cellStyle=  new JRDesignStyle();
        cellStyle.setName(baseName + "_TD");

        if (jToggleButton1.isSelected())
        {
            cellStyle.getLineBox().getPen().setLineColor( colorSelectorPanel1.getColor() );
            cellStyle.getLineBox().getPen().setLineWidth(0.5f);
        }
        else
        {
            cellStyle.getLineBox().getBottomPen().setLineColor( colorSelectorPanel1.getColor() );
            cellStyle.getLineBox().getBottomPen().setLineWidth(0.5f);
            cellStyle.getLineBox().getTopPen().setLineColor( colorSelectorPanel1.getColor() );
            cellStyle.getLineBox().getTopPen().setLineWidth(0.5f);
        }

        cellStyle.setMode(ModeEnum.OPAQUE);
        cellStyle.setBackcolor(Color.WHITE);


        if (jCheckBox1.isSelected())
        {
            JRDesignConditionalStyle condStyle = new JRDesignConditionalStyle();
            condStyle.setConditionExpression(Misc.createExpression("java.lang.Boolean", "new Boolean($V{REPORT_COUNT}.intValue()%2==0)"));

            Color c = ColorSchemaGenerator.createColor(previewPanel.getColor(), 2, previewPanel.getVariant());
            c = ColorSchemaGenerator.overlayWhite(c);
            c = ColorSchemaGenerator.overlayWhite(c);
            condStyle.setBackcolor(c);
            cellStyle.addConditionalStyle(condStyle);
        }

        styles.add(cellStyle);


        return styles;
    }
}
