/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBridge;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;

public class ExprNodeGenericFuncDesc
extends ExprNodeDesc
implements Serializable {
    private static final long serialVersionUID = 1L;
    private GenericUDF genericUDF;
    private List<ExprNodeDesc> childExprs;

    public ExprNodeGenericFuncDesc() {
    }

    public ExprNodeGenericFuncDesc(TypeInfo typeInfo, GenericUDF genericUDF, List<ExprNodeDesc> children) {
        super(typeInfo);
        assert (genericUDF != null);
        this.genericUDF = genericUDF;
        this.childExprs = children;
    }

    public GenericUDF getGenericUDF() {
        return this.genericUDF;
    }

    public void setGenericUDF(GenericUDF genericUDF) {
        this.genericUDF = genericUDF;
    }

    public List<ExprNodeDesc> getChildExprs() {
        return this.childExprs;
    }

    public void setChildExprs(List<ExprNodeDesc> children) {
        this.childExprs = children;
    }

    @Override
    public List<ExprNodeDesc> getChildren() {
        return this.childExprs;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.genericUDF.getClass().toString());
        sb.append("(");
        for (int i = 0; i < this.childExprs.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.childExprs.get(i).toString());
        }
        sb.append("(");
        sb.append(")");
        return sb.toString();
    }

    @Override
    @Explain(displayName="expr")
    public String getExprString() {
        String[] childrenExprStrings = new String[this.childExprs.size()];
        for (int i = 0; i < childrenExprStrings.length; ++i) {
            childrenExprStrings[i] = this.childExprs.get(i).getExprString();
        }
        return this.genericUDF.getDisplayString(childrenExprStrings);
    }

    @Override
    public List<String> getCols() {
        List<String> colList = new ArrayList<String>();
        if (this.childExprs != null) {
            for (int pos = 0; pos < this.childExprs.size(); ++pos) {
                List<String> colCh = this.childExprs.get(pos).getCols();
                colList = Utilities.mergeUniqElems(colList, colCh);
            }
        }
        return colList;
    }

    @Override
    public ExprNodeDesc clone() {
        ArrayList<ExprNodeDesc> cloneCh = new ArrayList<ExprNodeDesc>(this.childExprs.size());
        for (ExprNodeDesc ch : this.childExprs) {
            cloneCh.add(ch.clone());
        }
        ExprNodeGenericFuncDesc clone = new ExprNodeGenericFuncDesc(this.typeInfo, FunctionRegistry.cloneGenericUDF(this.genericUDF), cloneCh);
        return clone;
    }

    public static ExprNodeGenericFuncDesc newInstance(GenericUDF genericUDF, List<ExprNodeDesc> children) throws UDFArgumentException {
        ObjectInspector[] childrenOIs = new ObjectInspector[children.size()];
        for (int i = 0; i < childrenOIs.length; ++i) {
            childrenOIs[i] = TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo(children.get(i).getTypeInfo());
        }
        ObjectInspector oi = genericUDF.initialize(childrenOIs);
        return new ExprNodeGenericFuncDesc(TypeInfoUtils.getTypeInfoFromObjectInspector(oi), genericUDF, children);
    }

    @Override
    public boolean isSame(Object o) {
        if (!(o instanceof ExprNodeGenericFuncDesc)) {
            return false;
        }
        ExprNodeGenericFuncDesc dest = (ExprNodeGenericFuncDesc)o;
        if (!this.typeInfo.equals(dest.getTypeInfo()) || !this.genericUDF.getClass().equals(dest.getGenericUDF().getClass())) {
            return false;
        }
        if (this.genericUDF instanceof GenericUDFBridge) {
            GenericUDFBridge bridge = (GenericUDFBridge)this.genericUDF;
            GenericUDFBridge bridge2 = (GenericUDFBridge)dest.getGenericUDF();
            if (!bridge.getUdfClass().equals(bridge2.getUdfClass()) || !bridge.getUdfName().equals(bridge2.getUdfName()) || bridge.isOperator() != bridge2.isOperator()) {
                return false;
            }
        }
        if (this.childExprs.size() != dest.getChildExprs().size()) {
            return false;
        }
        for (int pos = 0; pos < this.childExprs.size(); ++pos) {
            if (this.childExprs.get(pos).isSame(dest.getChildExprs().get(pos))) continue;
            return false;
        }
        return true;
    }
}

