/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;

public class ExprNodeConstantDesc
extends ExprNodeDesc
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Object value;

    public ExprNodeConstantDesc() {
    }

    public ExprNodeConstantDesc(TypeInfo typeInfo, Object value) {
        super(typeInfo);
        this.value = value;
    }

    public ExprNodeConstantDesc(Object value) {
        this(TypeInfoFactory.getPrimitiveTypeInfoFromJavaPrimitive(value.getClass()), value);
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    public String toString() {
        return "Const " + this.typeInfo.toString() + " " + this.value;
    }

    @Override
    @Explain(displayName="expr")
    public String getExprString() {
        if (this.value == null) {
            return "null";
        }
        if (this.typeInfo.getTypeName().equals("string")) {
            return "'" + this.value.toString() + "'";
        }
        return this.value.toString();
    }

    @Override
    public ExprNodeDesc clone() {
        return new ExprNodeConstantDesc(this.typeInfo, this.value);
    }

    @Override
    public boolean isSame(Object o) {
        if (!(o instanceof ExprNodeConstantDesc)) {
            return false;
        }
        ExprNodeConstantDesc dest = (ExprNodeConstantDesc)o;
        if (!this.typeInfo.equals(dest.getTypeInfo())) {
            return false;
        }
        return this.value.equals(dest.getValue());
    }
}

