/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.FilterOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.Rule;
import org.apache.hadoop.hive.ql.lib.RuleRegExp;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.optimizer.Transform;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.FilterDesc;

public class SamplePruner
implements Transform {
    private static final Log LOG = LogFactory.getLog((String)"hive.ql.optimizer.SamplePruner");

    @Override
    public ParseContext transform(ParseContext pctx) throws SemanticException {
        SamplePrunerCtx samplePrunerCtx = new SamplePrunerCtx(pctx.getOpToSamplePruner());
        LinkedHashMap<Rule, NodeProcessor> opRules = new LinkedHashMap<Rule, NodeProcessor>();
        opRules.put(new RuleRegExp("R1", "(TS%FIL%FIL%)"), SamplePruner.getFilterProc());
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher(SamplePruner.getDefaultProc(), opRules, samplePrunerCtx);
        DefaultGraphWalker ogw = new DefaultGraphWalker(disp);
        ArrayList<Node> topNodes = new ArrayList<Node>();
        topNodes.addAll(pctx.getTopOps().values());
        ogw.startWalking(topNodes, null);
        return pctx;
    }

    public static NodeProcessor getFilterProc() {
        return new FilterPPR();
    }

    public static NodeProcessor getDefaultProc() {
        return new DefaultPPR();
    }

    public static Path[] prune(Partition part, FilterDesc.sampleDesc sampleDescr) throws SemanticException {
        int num = sampleDescr.getNumerator();
        int den = sampleDescr.getDenominator();
        int bucketCount = part.getBucketCount();
        String fullScanMsg = "";
        if (sampleDescr.getInputPruning()) {
            LOG.trace((Object)("numerator = " + num));
            LOG.trace((Object)("denominator = " + den));
            LOG.trace((Object)("bucket count = " + bucketCount));
            if (bucketCount == den) {
                Path[] ret = new Path[]{part.getBucketPath(num - 1)};
                return ret;
            }
            if (bucketCount > den && bucketCount % den == 0) {
                int numPathsInSample = bucketCount / den;
                Path[] ret = new Path[numPathsInSample];
                for (int i = 0; i < numPathsInSample; ++i) {
                    ret[i] = part.getBucketPath(i * den + num - 1);
                }
                return ret;
            }
            if (bucketCount < den && den % bucketCount == 0) {
                Path[] ret = new Path[]{part.getBucketPath((num - 1) % bucketCount)};
                return ret;
            }
            fullScanMsg = "Tablesample denominator " + den + " is not multiple/divisor of bucket count " + bucketCount + " of table " + part.getTable().getTableName();
        } else {
            fullScanMsg = "Tablesample not on clustered columns";
        }
        LOG.warn((Object)(fullScanMsg + ", using full table scan"));
        Path[] ret = part.getPath();
        return ret;
    }

    public static class DefaultPPR
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            return null;
        }
    }

    public static class FilterPPR
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            FilterOperator filOp = (FilterOperator)nd;
            FilterDesc filOpDesc = (FilterDesc)filOp.getConf();
            FilterDesc.sampleDesc sampleDescr = filOpDesc.getSampleDescr();
            if (sampleDescr == null || !sampleDescr.getInputPruning()) {
                return null;
            }
            assert (stack.size() == 3);
            TableScanOperator tsOp = (TableScanOperator)stack.get(0);
            ((SamplePrunerCtx)procCtx).getOpToSamplePruner().put(tsOp, sampleDescr);
            return null;
        }
    }

    public static class SamplePrunerCtx
    implements NodeProcessorCtx {
        HashMap<TableScanOperator, FilterDesc.sampleDesc> opToSamplePruner;

        public SamplePrunerCtx(HashMap<TableScanOperator, FilterDesc.sampleDesc> opToSamplePruner) {
            this.opToSamplePruner = opToSamplePruner;
        }

        public HashMap<TableScanOperator, FilterDesc.sampleDesc> getOpToSamplePruner() {
            return this.opToSamplePruner;
        }

        public void setOpToSamplePruner(HashMap<TableScanOperator, FilterDesc.sampleDesc> opToSamplePruner) {
            this.opToSamplePruner = opToSamplePruner;
        }
    }
}

