/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.IOContext;
import org.apache.hadoop.hive.ql.io.RCFile;
import org.apache.hadoop.hive.ql.io.RCFileRecordReader;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;

public abstract class HiveContextAwareRecordReader<K, V>
implements RecordReader<K, V> {
    private boolean initDone = false;
    private IOContext ioCxtRef = null;

    public abstract boolean doNext(K var1, V var2) throws IOException;

    public abstract void doClose() throws IOException;

    public void close() throws IOException {
        this.doClose();
        this.initDone = false;
        this.ioCxtRef = null;
    }

    public boolean next(K key, V value) throws IOException {
        if (!this.initDone) {
            throw new IOException("Hive IOContext is not inited.");
        }
        this.updateIOContext();
        try {
            return this.doNext(key, value);
        }
        catch (IOException e) {
            this.ioCxtRef.setIOExceptions(true);
            throw e;
        }
    }

    protected void updateIOContext() throws IOException {
        long pointerPos = this.getPos();
        if (!this.ioCxtRef.isBlockPointer) {
            this.ioCxtRef.currentBlockStart = pointerPos;
            return;
        }
        if (this.ioCxtRef.nextBlockStart == -1L) {
            this.ioCxtRef.nextBlockStart = pointerPos;
        }
        if (pointerPos != this.ioCxtRef.nextBlockStart) {
            this.ioCxtRef.currentBlockStart = this.ioCxtRef.nextBlockStart;
            this.ioCxtRef.nextBlockStart = pointerPos;
        }
    }

    public IOContext getIOContext() {
        return IOContext.get();
    }

    public void initIOContext(long startPos, boolean isBlockPointer, String inputFile) {
        this.ioCxtRef = this.getIOContext();
        this.ioCxtRef.currentBlockStart = startPos;
        this.ioCxtRef.isBlockPointer = isBlockPointer;
        this.ioCxtRef.inputFile = inputFile;
        this.initDone = true;
    }

    public void initIOContext(FileSplit split, JobConf job, Class inputFormatClass) throws IOException {
        this.initIOContext(split, job, inputFormatClass, null);
    }

    public void initIOContext(FileSplit split, JobConf job, Class inputFormatClass, RecordReader recordReader) throws IOException {
        boolean blockPointer = false;
        long blockStart = -1L;
        FileSplit fileSplit = split;
        Path path = fileSplit.getPath();
        FileSystem fs = path.getFileSystem((Configuration)job);
        if (inputFormatClass.getName().contains("SequenceFile")) {
            SequenceFile.Reader in = new SequenceFile.Reader(fs, path, (Configuration)job);
            blockPointer = in.isBlockCompressed();
            in.sync(fileSplit.getStart());
            blockStart = in.getPosition();
            in.close();
        } else if (recordReader instanceof RCFileRecordReader) {
            blockPointer = true;
            blockStart = ((RCFileRecordReader)recordReader).getStart();
        } else if (inputFormatClass.getName().contains("RCFile")) {
            blockPointer = true;
            RCFile.Reader in = new RCFile.Reader(fs, path, (Configuration)job);
            in.sync(fileSplit.getStart());
            blockStart = in.getPosition();
            in.close();
        }
        this.initIOContext(blockStart, blockPointer, split.getPath().toString());
    }
}

