/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.index.compact;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.index.compact.HiveCompactIndexResult;
import org.apache.hadoop.hive.ql.io.HiveFileFormatUtils;
import org.apache.hadoop.hive.ql.io.HiveInputFormat;
import org.apache.hadoop.hive.ql.io.IOPrepareCache;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;

public class HiveCompactIndexInputFormat
extends HiveInputFormat {
    public static final Log l4j = LogFactory.getLog((String)"HiveIndexInputFormat");

    public InputSplit[] doGetSplits(JobConf job, int numSplits) throws IOException {
        super.init(job);
        Path[] dirs = FileInputFormat.getInputPaths((JobConf)job);
        if (dirs.length == 0) {
            throw new IOException("No input paths specified in job");
        }
        JobConf newjob = new JobConf((Configuration)job);
        ArrayList<HiveInputFormat.HiveInputSplit> result = new ArrayList<HiveInputFormat.HiveInputSplit>();
        for (Path dir : dirs) {
            InputSplit[] iss;
            PartitionDesc part = HiveFileFormatUtils.getPartitionDescFromPathRecursively(this.pathToPartitionInfo, dir, IOPrepareCache.get().allocatePartitionDescMap(), true);
            Class<? extends InputFormat> inputFormatClass = part.getInputFileFormatClass();
            InputFormat<WritableComparable, Writable> inputFormat = HiveCompactIndexInputFormat.getInputFormatFromCache(inputFormatClass, job);
            Utilities.copyTableJobPropertiesToConf(part.getTableDesc(), newjob);
            FileInputFormat.setInputPaths((JobConf)newjob, (Path[])new Path[]{dir});
            newjob.setInputFormat(inputFormat.getClass());
            for (InputSplit is : iss = inputFormat.getSplits(newjob, numSplits / dirs.length)) {
                result.add(new HiveInputFormat.HiveInputSplit(is, inputFormatClass.getName()));
            }
        }
        return result.toArray(new HiveInputFormat.HiveInputSplit[result.size()]);
    }

    @Override
    public InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
        StringBuilder newInputPaths;
        String indexFileStr = job.get("hive.index.compact.file");
        l4j.info((Object)("index_file is " + indexFileStr));
        HiveCompactIndexResult hiveIndexResult = null;
        if (indexFileStr != null) {
            try {
                hiveIndexResult = new HiveCompactIndexResult(indexFileStr, job);
            }
            catch (HiveException e) {
                l4j.error((Object)"Unable to read index..");
                throw new IOException(e);
            }
            Set<String> inputFiles = hiveIndexResult.buckets.keySet();
            Iterator<String> iter = inputFiles.iterator();
            boolean first = true;
            newInputPaths = new StringBuilder();
            while (iter.hasNext()) {
                String path = iter.next();
                if (path.trim().equalsIgnoreCase("")) continue;
                if (!first) {
                    newInputPaths.append(",");
                } else {
                    first = false;
                }
                newInputPaths.append(path);
            }
        } else {
            return super.getSplits(job, numSplits);
        }
        FileInputFormat.setInputPaths((JobConf)job, (String)newInputPaths.toString());
        HiveInputFormat.HiveInputSplit[] splits = (HiveInputFormat.HiveInputSplit[])this.doGetSplits(job, numSplits);
        ArrayList<HiveInputFormat.HiveInputSplit> newSplits = new ArrayList<HiveInputFormat.HiveInputSplit>(numSplits);
        for (HiveInputFormat.HiveInputSplit split : splits) {
            l4j.info((Object)("split start : " + split.getStart()));
            l4j.info((Object)("split end : " + (split.getStart() + split.getLength())));
            try {
                if (!hiveIndexResult.contains(split)) continue;
                HiveInputFormat.HiveInputSplit newSplit = split;
                if ((split.inputFormatClassName().contains("RCFile") || split.inputFormatClassName().contains("SequenceFile")) && split.getStart() > 2000L) {
                    newSplit = new HiveInputFormat.HiveInputSplit((InputSplit)new FileSplit(split.getPath(), split.getStart() - 2000L, split.getLength() + 2000L, split.getLocations()), split.inputFormatClassName());
                }
                newSplits.add(newSplit);
            }
            catch (HiveException e) {
                throw new RuntimeException("Unable to get metadata for input table split" + split.getPath());
            }
        }
        InputSplit[] retA = (InputSplit[])newSplits.toArray(new FileSplit[newSplits.size()]);
        l4j.info((Object)("Number of input splits: " + splits.length + " new input splits: " + retA.length));
        return retA;
    }
}

